-- 10.1.init.sql

/*
将 paas.example.com 替换为 paas.学校域名.edu.cn
*/


-- 以下脚本为可选操作

/*
 * 若部署了流程平台、门户的产品
 * 可默认创建几个管理员帐号，以及初始授权
 */


-- 创建管理帐号

use user;

-- portaladmin
INSERT INTO `TB_B_USER` (`ID`, `DELETED`, 
  `UID`, `PASSWORD`, `NAME`, `NAME_SPELLING`, `FULL_NAME_SPELLING`, 
  `CERTIFICATE_TYPE_ID`, `CERTIFICATE_NUMBER`, `PHONE_NUMBER`, `EMAIL`,
  `GENDER_ID`, `NATION_ID`, `COUNTRY_ID`, `ADDRESS_ID`)
VALUES ('60', 0, 
  '60', 'portaladmin', '门户管理员', 'portaladmin', 'portaladmin', 
  '20001', '60', null, 'portaladmin@supwisdom.com',
  '30001', '40001', '50156', '310000');

INSERT INTO `TB_B_ACCOUNT` (`ID`, `DELETED`, `USER_ID`, 
  `ACCOUNT_NAME`, `ACCOUNT_EXPIRY_DATE`, `ORGANIZATION_ID`, `IDENTITY_TYPE_ID`, 
  `ACTIVATION`, `STATE`, `IS_DATA_CENTER`)
VALUES ('60', 0, '60', 
  'portaladmin', null, '1', '1',
  1, 'NORMAL', 0);

INSERT INTO `TB_B_SAFETY`(`ID`, `DELETED`, `USER_ID`, `SCORE`, `PASSWORD_SCORE`, `SECURE_EMAIL`, `SECURE_PHONE`)
VALUES ('60', 0, '60', '0', '0', null, null);

INSERT INTO `TB_B_ACCOUNT_ORGANIZATION` (`ID`, `DELETED`, 
  `ROOT_ORGANIZATION_ID`, `ACCOUNT_ID`, `ORGANIZATION_ID`)
VALUES ('60_1', 0, 
  '0', '60', '1');

INSERT INTO `TB_B_ACCOUNT_LABEL`(`ID`, `DELETED`, 
  `ACCOUNT_ID`, `LABEL_ID`)
VALUES ('60_1', 0, '60', '1');

commit;


-- 创建管理帐号的授权

use user_authz;

-- portal
INSERT INTO `TB_SYSTEM` (`ID`, `COMPANY_ID`, `DELETED`, `ADD_ACCOUNT`, `ADD_TIME`, 
  `BUSINESS_DOMAIN_ID`, 
  `CODE`, `NAME`, `DESCRIPTION`, `ENABLED`)
VALUES ('60', '1', 0, 'admin', '2019-07-01 00:00:00', 
  '1', 
  'portal', '门户', '门户', 1);

INSERT INTO `TB_APPLICATION` (`ID`, `COMPANY_ID`, `DELETED`, `ADD_ACCOUNT`, `ADD_TIME`, 
  `BUSINESS_DOMAIN_ID`, `SYSTEM_ID`, 
  `NAME`, `APPLICATION_ID`, `SYNC_URL`, `ENABLED`)
VALUES ('60', '1', 0, 'admin', '2019-07-01 00:00:00', 
  '1', '60', 
  '门户', '60', '', 1);

INSERT INTO `TB_ROLE` (`ID`, `COMPANY_ID`, `DELETED`, `ADD_ACCOUNT`, `ADD_TIME`, 
  `APPLICATION_ID`, `CODE`, `NAME`, `DESCRIPTION`, `ENABLED`, `EXTERNAL_ID`)
VALUES ('60', '1', 0, 'admin', '2019-07-01 00:00:00', 
  '60', 'portal-admin', '门户管理员', '门户管理员', 1, '60');

INSERT INTO `TB_ROLE_USER` (`ID`, `COMPANY_ID`, `DELETED`, `ADD_ACCOUNT`, `ADD_TIME`,
  `ORIGIN_TYPE`, `ORIGIN_PK`, 
  `APPLICATION_ID`, `ROLE_ID`, `ACCOUNT_ID`, 
  `GRANT_EXPIRED_DATE`)
VALUES ('60_60_60', '1', 0, 'admin', '2019-07-01 00:00:00',
  NULL, NULL, 
  '60', '60', '60', 
  NULL);

commit;


-- 配置门户角色的同步接口

update TB_APPLICATION
set
  SYNC_URL='http://portal.paas.example.com/portal-web/api/open/role/findAll'
where ID='60';  -- todo, modify

commit;


-- 创建认证帐号、认证对接

use cas_server;

-- portal

INSERT INTO `TB_ACCOUNT` (`ID`, `COMPANY_ID`, `DELETED`, `ADD_ACCOUNT`, `ADD_TIME`, 
  `USERNAME`, `PASSWORD`, `DESCRIPTION`, `ENABLED`, `ACCOUNT_NON_EXPIRED`, `ACCOUNT_NON_LOCKED`, `CREDENTIALS_NON_EXPIRED`,
  `IDENTITY`, `USER_NO`, `NAME`, `MOBILE`, `EMAIL_ADDRESS`, `IDENTITY_TYPE`, `IDENTITY_NO`, 
  `EXTERNAL_ID`)
VALUES ('60', '1', 0, 'admin', '2019-07-01 00:00:00',
  'portaladmin', 'portaladmin', '门户管理员', 1, 1, 1, 1,
  'admin', '60', '门户管理员', '', 'portaladmin@supwisdom.com', '20001', '', 
  '60');

commit;


INSERT INTO `TB_SERVICE` (`ID`, `COMPANY_ID`, `DELETED`, `ADD_ACCOUNT`, `ADD_TIME`, 
  `NAME`, `DESCRIPTION`, `INFORMATION_URL`, `LOGOUT_URL`, 
  `RESPONSE_TYPE`, `LOGOUT_TYPE`, 
  `EVALUATION_ORDER`, `FRIENDLY_NAME`, `REGISTERED_SERVICE_ID`, `SERVICE_ID`, 
  `ENABLED`, `SSO_ENABLED`, `REQUIRE_ALL_ATTRIBUTES`, 
  `APPLICATION_ID`, `EXTERNAL_ID`)
VALUES ('60', '1', 0, 'admin', '2019-07-01 00:00:00',
  '门户', '门户', 'https://ecampus.paas.example.com', 'https://ecampus.paas.example.com/cas/slo', 
  'REDIRECT', 'FRONT_CHANNEL', 
  60, '门户', 60, 'https://ecampus.paas.example.com/login', 
  1, 1, 1, 
  '60', '60');

commit;

update TB_SERVICE 
set 
  INFORMATION_URL='http://ecampus.paas.example.com', 
  LOGOUT_URL='http://ecampus.paas.example.com/cas/slo', 
  SERVICE_ID='http://ecampus.paas.example.com/cas/(.*)', 
  ID_TOKEN_ENABLED=1 
where ID='60';  -- todo, modify

commit;

