-- 10.1.init.sql

/*
将 paas.example.com 替换为 paas.学校域名.edu.cn
*/

-- 以下脚本为可选操作

/*
 * 若部署了流程平台、门户的产品
 * 可初始化云平台下的相关菜单数据
 */

use admin_center;

-- portal
-- 如果部署，门户V5，请处理

insert into TB_MGT_ROUTE (ID, DELETED, CODE, NAME, STATUS, PATH_PREFIX, URL, STRIP_PREFIX) 
values ('60', 0, 'portal-api', '管理门户 - 门户接口', '1', '/api/v1/portal', 'http://ecampus.paas.example.com/', 1);

commit;


update TB_MGT_ROUTE 
set 
  URL='http://ecampus.paas.example.com' 
where ID='60';  -- todo, modify

commit;
/*
http://portal-web.portal.svc.cluster.local:8080/portal-web/api
*/


insert into TB_MGT_ROLE (ID, DELETED, CODE, NAME, MEMO, STATUS) 
values ('60', 0, 'portal-admin', '门户管理员', '', '1');

commit;


/*
update TB_MGT_PERMISSION
  set LFT = LFT+10
where LFT>=89
;

update TB_MGT_PERMISSION
  set RGT = RGT+10
where RGT>=89
;
*/


/*
门户管理
  web端管理
    系统管理
    组件模板
    主题管理
    主题方案
  授权管理
    角色管理
  服务管理
    服务管理
    服务评价管理
    标签分类管理
  CMS管理
    幻灯片管理
    栏目管理
    内容管理
    流程管理
    模板管理
    滚动公告管理
  消息管理
    第三方消息发送设置
    消息类型管理
    消息发送详情
*/

insert into TB_MGT_PERMISSION (ID, DELETED, CODE, NAME, STATUS, TYPE_, ICON, URL, 
  APPLICATION_ID, PARENT_ID, ORDER_, LEVEL_, LFT, RGT) 
values ('60', 0, 'portal-manage', '门户管理', '1', '1', 'el-icon-s-help', '/', 
  '60', '0', 60, 1, 93, 136);

insert into TB_MGT_PERMISSION (ID, DELETED, CODE, NAME, 
  STATUS, TYPE_, ICON, URL, 
  APPLICATION_ID, PARENT_ID, ORDER_, LEVEL_, LFT, RGT) 
values ('6010000', 0, 'web', 'web端管理', 
  '1', '2', null, null, 
  '60', '60', 6010000, 1, 94, 105);

insert into TB_MGT_PERMISSION (ID, DELETED, CODE, NAME, 
  STATUS, TYPE_, ICON, URL, 
  APPLICATION_ID, PARENT_ID, ORDER_, LEVEL_, LFT, RGT) 
values ('6010001', 0, 'web-systemManager', '系统管理', 
  '1', '2', 'su-icon-xitongguanli', 'http://ecampus.paas.example.com/portal-web/html/admin/index.html#web/systemManager/view.html', 
  '60', '6010000', 6010001, 2, 95, 96);

insert into TB_MGT_PERMISSION (ID, DELETED, CODE, NAME, 
  STATUS, TYPE_, ICON, URL, 
  APPLICATION_ID, PARENT_ID, ORDER_, LEVEL_, LFT, RGT) 
values ('6010002', 0, 'web-widgetTemplate', '组件模板', 
  '1', '2', 'su-icon-zujianmoban', 'http://ecampus.paas.example.com/portal-web/html/admin/index.html#web/widgetTemplate/view.html', 
  '60', '6010000', 6010002, 2, 97, 98);

insert into TB_MGT_PERMISSION (ID, DELETED, CODE, NAME, 
  STATUS, TYPE_, ICON, URL, 
  APPLICATION_ID, PARENT_ID, ORDER_, LEVEL_, LFT, RGT) 
values ('6010003', 0, 'web-themeManager', '主题管理', 
  '1', '2', 'su-icon-hutiguanli', 'http://ecampus.paas.example.com/portal-web/html/admin/index.html#web/themeManager/view.html', 
  '60', '6010000', 6010003, 2, 99, 100);

insert into TB_MGT_PERMISSION (ID, DELETED, CODE, NAME, 
  STATUS, TYPE_, ICON, URL, 
  APPLICATION_ID, PARENT_ID, ORDER_, LEVEL_, LFT, RGT) 
values ('6010004', 0, 'web-themeScheme', '主题方案', 
  '1', '2', 'su-icon-zhutifangan', 'http://ecampus.paas.example.com/portal-web/html/admin/index.html#web/themeScheme/view.html', 
  '60', '6010000', 6010004, 2, 101, 102);

insert into TB_MGT_PERMISSION (ID, DELETED, CODE, NAME, 
  STATUS, TYPE_, ICON, URL, 
  APPLICATION_ID, PARENT_ID, ORDER_, LEVEL_, LFT, RGT) 
values ('6010005', 0, 'web-oauthManager', 'oauth管理', 
  '1', '2', 'su-icon-authguanli', 'http://ecampus.paas.example.com/portal-web/html/admin/index.html#web/oauthManager/view.html', 
  '60', '6010000', 6010005, 2, 103, 104);

insert into TB_MGT_PERMISSION (ID, DELETED, CODE, NAME, 
  STATUS, TYPE_, ICON, URL, 
  APPLICATION_ID, PARENT_ID, ORDER_, LEVEL_, LFT, RGT) 
values ('6020000', 0, 'auth', '授权管理', 
  '1', '2', null, null, 
  '60', '60', 6020000, 1, 106, 109);

insert into TB_MGT_PERMISSION (ID, DELETED, CODE, NAME, 
  STATUS, TYPE_, ICON, URL, 
  APPLICATION_ID, PARENT_ID, ORDER_, LEVEL_, LFT, RGT) 
values ('6020003', 0, 'auth-roleManager', '角色管理', 
  '1', '2', 'su-icon-jiaoseguanli', 'http://ecampus.paas.example.com/portal-web/html/admin/index.html#auth/roleManager/view.html', 
  '60', '6020000', 6020003, 2, 107, 108);

insert into TB_MGT_PERMISSION (ID, DELETED, CODE, NAME, 
  STATUS, TYPE_, ICON, URL, 
  APPLICATION_ID, PARENT_ID, ORDER_, LEVEL_, LFT, RGT) 
values ('6030000', 0, 'service', '服务管理', 
  '1', '2', null, null, 
  '60', '60', 6030000, 1, 110, 117);

insert into TB_MGT_PERMISSION (ID, DELETED, CODE, NAME, 
  STATUS, TYPE_, ICON, URL, 
  APPLICATION_ID, PARENT_ID, ORDER_, LEVEL_, LFT, RGT) 
values ('6030001', 0, 'service-appservice', '服务管理', 
  '1', '2', 'su-icon-fuwuguanli', 'http://ecampus.paas.example.com/portal-web/html/admin/index.html#service/appservice/tabs.html', 
  '60', '6030000', 6030001, 2, 111, 112);

insert into TB_MGT_PERMISSION (ID, DELETED, CODE, NAME, 
  STATUS, TYPE_, ICON, URL, 
  APPLICATION_ID, PARENT_ID, ORDER_, LEVEL_, LFT, RGT) 
values ('6030002', 0, 'service-evaluate', '服务评价管理', 
  '1', '2', 'su-icon-fuwupingjiaguanli', 'http://ecampus.paas.example.com/portal-web/html/admin/index.html#service/evaluate/form.html', 
  '60', '6030000', 6030002, 2, 113, 114);

insert into TB_MGT_PERMISSION (ID, DELETED, CODE, NAME, 
  STATUS, TYPE_, ICON, URL, 
  APPLICATION_ID, PARENT_ID, ORDER_, LEVEL_, LFT, RGT) 
values ('6030003', 0, 'service-tagging', '标签分类管理', 
  '1', '2', 'su-icon-biaoqianfenleiguanli', 'http://ecampus.paas.example.com/portal-web/html/admin/index.html#service/tagging/form.html', 
  '60', '6030000', 6030003, 2, 115, 116);

insert into TB_MGT_PERMISSION (ID, DELETED, CODE, NAME, 
  STATUS, TYPE_, ICON, URL, 
  APPLICATION_ID, PARENT_ID, ORDER_, LEVEL_, LFT, RGT) 
values ('6040000', 0, 'cms', 'CMS管理', 
  '1', '2', null, null, 
  '60', '60', 6040000, 1, 118, 131);

insert into TB_MGT_PERMISSION (ID, DELETED, CODE, NAME, 
  STATUS, TYPE_, ICON, URL, 
  APPLICATION_ID, PARENT_ID, ORDER_, LEVEL_, LFT, RGT) 
values ('6040001', 0, 'cms-slide', '幻灯片管理', 
  '1', '2', 'su-icon-huandengpianguanli', 'http://ecampus.paas.example.com/portal-web/html/admin/index.html#cms/slide/list.html', 
  '60', '6040000', 6040001, 2, 119, 120);

insert into TB_MGT_PERMISSION (ID, DELETED, CODE, NAME, 
  STATUS, TYPE_, ICON, URL, 
  APPLICATION_ID, PARENT_ID, ORDER_, LEVEL_, LFT, RGT) 
values ('6040002', 0, 'cms-column', '栏目管理', 
  '1', '2', 'su-icon-lanmuguanli', 'http://ecampus.paas.example.com/portal-web/html/admin/index.html#cms/column/list.html', 
  '60', '6040000', 6040002, 2, 121, 122);

insert into TB_MGT_PERMISSION (ID, DELETED, CODE, NAME, 
  STATUS, TYPE_, ICON, URL, 
  APPLICATION_ID, PARENT_ID, ORDER_, LEVEL_, LFT, RGT) 
values ('6040003', 0, 'cms-content', '内容管理', 
  '1', '2', 'su-icon-neirongguanli', 'http://ecampus.paas.example.com/portal-web/html/admin/index.html#cms/content/list-manage.html', 
  '60', '6040000', 6040003, 2, 123, 124);

insert into TB_MGT_PERMISSION (ID, DELETED, CODE, NAME, 
  STATUS, TYPE_, ICON, URL, 
  APPLICATION_ID, PARENT_ID, ORDER_, LEVEL_, LFT, RGT) 
values ('6040004', 0, 'cms-flow', '流程管理', 
  '1', '2', 'su-icon-liuchengguanli', 'http://ecampus.paas.example.com/portal-web/html/admin/index.html#cms/flow/list.html', 
  '60', '6040000', 6040004, 2, 125, 126);

insert into TB_MGT_PERMISSION (ID, DELETED, CODE, NAME, 
  STATUS, TYPE_, ICON, URL, 
  APPLICATION_ID, PARENT_ID, ORDER_, LEVEL_, LFT, RGT) 
values ('6040005', 0, 'cms-template', '模板管理', 
  '1', '2', 'su-icon-mobanguanli', 'http://ecampus.paas.example.com/portal-web/html/admin/index.html#cms/template/list.html', 
  '60', '6040000', 6040005, 2, 127, 128);

insert into TB_MGT_PERMISSION (ID, DELETED, CODE, NAME, 
  STATUS, TYPE_, ICON, URL, 
  APPLICATION_ID, PARENT_ID, ORDER_, LEVEL_, LFT, RGT) 
values ('6040006', 0, 'cms-notice', '滚动公告管理', 
  '1', '2', 'su-icon-gundonggonggaoguanli', 'http://ecampus.paas.example.com/portal-web/html/admin/index.html#cms/notice/list.html', 
  '60', '6040000', 6040006, 2, 129, 130);

insert into TB_MGT_PERMISSION (ID, DELETED, CODE, NAME, 
  STATUS, TYPE_, ICON, URL, 
  APPLICATION_ID, PARENT_ID, ORDER_, LEVEL_, LFT, RGT) 
values ('6050000', 0, 'message', '消息管理', 
  '1', '2', null, null, 
  '60', '60', 6050000, 1, 132, 139);

insert into TB_MGT_PERMISSION (ID, DELETED, CODE, NAME, 
  STATUS, TYPE_, ICON, URL, 
  APPLICATION_ID, PARENT_ID, ORDER_, LEVEL_, LFT, RGT) 
values ('6050001', 0, 'message-sendsetting', '第三方消息发送设置', 
  '1', '2', 'su-icon-disanfangxiaoxifasongshezhi', 'http://ecampus.paas.example.com/portal-web/html/admin/index.html#message/sendsetting/tabs.html', 
  '60', '6050000', 6050001, 2, 133, 134);

insert into TB_MGT_PERMISSION (ID, DELETED, CODE, NAME, 
  STATUS, TYPE_, ICON, URL, 
  APPLICATION_ID, PARENT_ID, ORDER_, LEVEL_, LFT, RGT) 
values ('6050002', 0, 'message-type', '消息类型管理', 
  '1', '2', 'su-icon-xiaoxileixingguanli', 'http://ecampus.paas.example.com/portal-web/html/admin/index.html#message/type/form.html', 
  '60', '6050000', 6050002, 2, 135, 136);

insert into TB_MGT_PERMISSION (ID, DELETED, CODE, NAME, 
  STATUS, TYPE_, ICON, URL, 
  APPLICATION_ID, PARENT_ID, ORDER_, LEVEL_, LFT, RGT) 
values ('6050003', 0, 'message-log', '消息发送详情', 
  '1', '2', 'su-icon-xiaoxifasongxiangqing', 'http://ecampus.paas.example.com/portal-web/html/admin/index.html#message/sendlog/list.html', 
  '60', '6050000', 6050003, 2, 137, 138);


commit;



insert into TB_MGT_ROLE_PERMISSION (ID, DELETED, ROLE_ID, PERMISSION_ID) 

select CONCAT('1_', ID) as ID, 0 as DELETED, '1' as ROLE_ID, ID as PERMISSION_ID 
from TB_MGT_PERMISSION
where ID like '60_____' or ID='60'
;



insert into TB_MGT_ROLE_PERMISSION (ID, DELETED, ROLE_ID, PERMISSION_ID) 

select CONCAT('60_', ID) as ID, 0 as DELETED, '60' as ROLE_ID, ID as PERMISSION_ID 
from TB_MGT_PERMISSION
where ID like '60_____' or ID='60' or ID='1'
;

commit;


/* 更新 TB_MGT_PERMISSION 的 ORIGIN */
/*
select * 
from TB_MGT_PERMISSION
where LFT >= (select LFT from TB_MGT_PERMISSION where ID='1')
  and RGT <= (select RGT from TB_MGT_PERMISSION where ID='1')
;
*/

update TB_MGT_PERMISSION
set 
  ORIGIN='http://ecampus.paas.example.com'
where APPLICATION_ID = '60'
;

commit;

