-- 10.0.init.sql


use cas_server;

-- 更新 服务 personal-security-center 的信息

update TB_SERVICE 
set 
  INFORMATION_URL='http://personal-security-center.paas.example.com', 
  LOGOUT_URL='http://personal-security-center.paas.example.com/cas/slo?redirect_uri=https://security-center.paas.example.com/?clearCertification=clearCertification',
  SERVICE_ID='http://personal-security-center.paas.example.com/cas/(.*)'
where ID='2';  -- todo, modify


-- security-center-ui 认证对接信息

INSERT INTO `TB_SERVICE` (`ID`, `COMPANY_ID`, `DELETED`, `ADD_ACCOUNT`, `ADD_TIME`, 
  `NAME`, `DESCRIPTION`, `INFORMATION_URL`, `LOGOUT_URL`, 
  `RESPONSE_TYPE`, `LOGOUT_TYPE`, 
  `EVALUATION_ORDER`, `FRIENDLY_NAME`, `REGISTERED_SERVICE_ID`, `SERVICE_ID`, 
  `ENABLED`, `SSO_ENABLED`, `REQUIRE_ALL_ATTRIBUTES`, 
  `APPLICATION_ID`, `EXTERNAL_ID`)
VALUES ('22', '1', 0, 'admin', '2020-07-01 00:00:00',
  '安全中心', '安全中心', 'https://security-center.paas.example.com', 'https://security-center.paas.example.com/?clearCertification=clearCertification', 
  'REDIRECT', 'FRONT_CHANNEL', 
  22, '安全中心', 22, 'https://security-center.paas.example.com/(.*)', 
  1, 1, 1, 
  '22', '22');

commit;

-- 修改根域名
update TB_SERVICE 
set 
  INFORMATION_URL='http://security-center.paas.example.com', 
  LOGOUT_URL='http://security-center.paas.example.com/?clearCertification=clearCertification', 
  SERVICE_ID='http://security-center.paas.example.com/(.*)', 
  ID_TOKEN_ENABLED=1,
  JWT_AS_SERVICE_TICKET=1,
  APPLICATION_DOMAIN='security-center.paas.example.com'
where ID='22';  -- todo, modify

commit;


-- 请注意图片的后缀名，须与实际的文件名保持一致
update TB_CONFIG set CONFIG_VALUE='cas-server-site-ui__logo.png' where ID='51'; -- casServer.config.logo
update TB_CONFIG set CONFIG_VALUE='cas-server-site-ui__logo.png' where ID='52'; -- casServer.config.logoM

update TB_CONFIG set CONFIG_VALUE='cas-server-site-ui__bg.png' where ID='53'; -- casServer.config.bg
update TB_CONFIG set CONFIG_VALUE='cas-server-site-ui__bg.png' where ID='54'; -- casServer.config.bgM

update TB_CONFIG set CONFIG_VALUE='409EFF' where ID='55'; -- casServer.config.schemeColor

update TB_CONFIG set CONFIG_VALUE='cas-server-site-ui__icon.png' where ID='56'; -- casServer.config.iconImageUrl

update TB_CONFIG set CONFIG_VALUE='https://example.com/download.htm' where ID='57';  -- casServer.config.superappDownloadUrl
update TB_CONFIG set CONFIG_VALUE='超级APP' where ID='57-1';  -- casServer.config.superappName

update TB_CONFIG set CONFIG_VALUE='cas-server-site-ui__favicon.ico' where ID='58'; -- casServer.config.webFavicon
update TB_CONFIG set CONFIG_VALUE='树维信息' where ID='59'; -- casServer.config.webTitle

update TB_CONFIG set CONFIG_VALUE='' where ID='61'; -- casServer.config.copyrightContent
update TB_CONFIG set CONFIG_VALUE='' where ID='62'; -- casServer.config.copyrightContentM


use user;

-- **配置 身份对应的帐号 须自动关联的 用户组**

/*

IDENTITY_TYPE

1     admin         系统用户

T01   T01           教职工

S01   S01           本科生
S02   S02           研究生
S03   S03           非学历生

P01   P01           聘用人员
P02   P02           外聘教师
P99   P99           在职/企业博士后


GROUP

11  teacher       教职工用户组
12  student       本科生用户组
13  graduate      研究生用户组
14  fellow        校友用户组

16  admin         管理人员用户组
17  retire        退休用户组

010883e0ac5e11eaaaee297ae5eef932    bsh           在职/企业博士后

23f87450ac5e11eaaaee297ae5eef932    wpjs          外聘教师
f1e42c20ac5d11eaaaee297ae5eef932    pyry          聘用人员

ffa610e0ac6111eaaaee297ae5eef932    fxls          非学历生用户组

*/


insert into TB_B_IDENTITY_TYPE_GROUP_INITIAL (ID, DELETED, ADD_ACCOUNT, IDENTITY_TYPE_ID, GROUP_ID)
values ('1', 0, 'init', 'T01', '11');

insert into TB_B_IDENTITY_TYPE_GROUP_INITIAL (ID, DELETED, ADD_ACCOUNT, IDENTITY_TYPE_ID, GROUP_ID)
values ('2', 0, 'init', 'S01', '12');

insert into TB_B_IDENTITY_TYPE_GROUP_INITIAL (ID, DELETED, ADD_ACCOUNT, IDENTITY_TYPE_ID, GROUP_ID)
values ('3', 0, 'init', 'S02', '13');

insert into TB_B_IDENTITY_TYPE_GROUP_INITIAL (ID, DELETED, ADD_ACCOUNT, IDENTITY_TYPE_ID, GROUP_ID)
values ('4', 0, 'init', 'S03', 'ffa610e0ac6111eaaaee297ae5eef932');

insert into TB_B_IDENTITY_TYPE_GROUP_INITIAL (ID, DELETED, ADD_ACCOUNT, IDENTITY_TYPE_ID, GROUP_ID)
values ('5', 0, 'init', 'P01', 'f1e42c20ac5d11eaaaee297ae5eef932');

insert into TB_B_IDENTITY_TYPE_GROUP_INITIAL (ID, DELETED, ADD_ACCOUNT, IDENTITY_TYPE_ID, GROUP_ID)
values ('6', 0, 'init', 'P02', '23f87450ac5e11eaaaee297ae5eef932');

insert into TB_B_IDENTITY_TYPE_GROUP_INITIAL (ID, DELETED, ADD_ACCOUNT, IDENTITY_TYPE_ID, GROUP_ID)
values ('7', 0, 'init', 'P99', '010883e0ac5e11eaaaee297ae5eef932');

commit;

