package com.supwisdom.institute.backend.admin.bff.api.v1.controller.me;

import java.util.ArrayList;
import java.util.List;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.MimeTypeUtils;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

import com.supwisdom.institute.backend.admin.bff.api.v1.model.base.Permission;
import com.supwisdom.institute.backend.admin.bff.api.v1.model.me.CurrentUser;
import com.supwisdom.institute.backend.admin.bff.api.v1.model.me.GrantedMenu;
import com.supwisdom.institute.backend.admin.bff.api.v1.service.base.AuthnService;
import com.supwisdom.institute.backend.admin.bff.api.v1.vo.me.response.data.CurrentUserResponseData;
import com.supwisdom.institute.backend.admin.bff.api.v1.vo.me.response.data.GrantedMenusResponseData;
import com.supwisdom.institute.backend.admin.bff.utils.CurrentUserUtil;
import com.supwisdom.institute.backend.common.core.transmit.user.User;
import com.supwisdom.institute.backend.common.framework.entity.EntityUtils;
import com.supwisdom.institute.backend.common.framework.vo.response.DefaultApiResponse;


@Api(value = "BFFMe", tags = { "me" }, description = "登录用户相关信息的接口")
@RestController
@RequestMapping(value = "/v1/me")
public class MeController {
  
  @Autowired
  private AuthnService authnService;
  
  @ApiOperation(
      tags = { "me" },
      value = "获取登录用户的基本信息", notes = "获取登录用户的基本信息", nickname = "user"
  )
  @RequestMapping(method = RequestMethod.GET, path = "/user", produces = MimeTypeUtils.APPLICATION_JSON_VALUE)
  public DefaultApiResponse<CurrentUserResponseData> user() {
    
    User user = CurrentUserUtil.currentUser();
    
    CurrentUser cu = new CurrentUser();
    cu.setUsername(user.getUsername());
    cu.setRoles(user.getRoles());
    cu.setAttributes(user.getAttributes());
    
    // XXX: 如果需要放入其他信息，可以扩展CurrentUser，并从服务接口中获取后写入数据
    
    CurrentUserResponseData data = CurrentUserResponseData.of(cu);
    return new DefaultApiResponse<CurrentUserResponseData>(data);
  }
  
  @ApiOperation(
      tags = { "me" },
      value = "获取登录用户的访问菜单", notes = "获取登录用户的访问菜单", nickname = "accountMenus"
  )
  @RequestMapping(method = RequestMethod.GET, path = "/menus", produces = MimeTypeUtils.APPLICATION_JSON_VALUE)
  public DefaultApiResponse<GrantedMenusResponseData> accountMenus() {
    
    String username = CurrentUserUtil.currentUsername();
    
    List<Permission> menus =  authnService.menus(username, "1");  // XXX: applicationId
    
    List<GrantedMenu> grantedMenus = new ArrayList<>();
    
    menus.forEach(m -> {
      GrantedMenu grantedMenu = new GrantedMenu();
      grantedMenu = EntityUtils.copy(m, grantedMenu);
      grantedMenus.add(grantedMenu);
    });
    
    GrantedMenusResponseData data = GrantedMenusResponseData.of(grantedMenus);
    return new DefaultApiResponse<GrantedMenusResponseData>(data);
    
  }
  
}
