package com.supwisdom.institute.backend.base.api.v1.controller.authn;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

import io.swagger.annotations.Api;
import lombok.extern.slf4j.Slf4j;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.util.MimeTypeUtils;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;

import com.supwisdom.institute.backend.base.api.v1.vo.authn.response.AuthnAccountPermissionsResponseData;
import com.supwisdom.institute.backend.base.api.v1.vo.authn.response.AuthnAccountResourcesResponseData;
import com.supwisdom.institute.backend.base.api.v1.vo.authn.response.AuthnAccountResponseData;
import com.supwisdom.institute.backend.base.api.v1.vo.authn.response.AuthnAccountRolesResponseData;
import com.supwisdom.institute.backend.base.api.v1.vo.authn.response.AuthnApplicationsResponseData;
import com.supwisdom.institute.backend.base.api.v1.vo.authn.response.AuthnPermissionRoleListResponseData;
import com.supwisdom.institute.backend.base.api.v1.vo.authn.response.AuthnResourceRoleListResponseData;
import com.supwisdom.institute.backend.base.api.v1.vo.authn.response.AuthnRolesResponseData;
import com.supwisdom.institute.backend.base.api.v1.vo.authn.response.AuthnRoutesResponseData;
import com.supwisdom.institute.backend.base.domain.entity.Account;
import com.supwisdom.institute.backend.base.domain.entity.Application;
import com.supwisdom.institute.backend.base.domain.entity.Permission;
import com.supwisdom.institute.backend.base.domain.entity.Resource;
import com.supwisdom.institute.backend.base.domain.entity.Role;
import com.supwisdom.institute.backend.base.domain.entity.Route;
import com.supwisdom.institute.backend.base.domain.model.PermissionRoleSet;
import com.supwisdom.institute.backend.base.domain.model.ResourceRoleSet;
import com.supwisdom.institute.backend.base.domain.service.AccountService;
import com.supwisdom.institute.backend.base.domain.service.ApplicationService;
import com.supwisdom.institute.backend.base.domain.service.PermissionService;
import com.supwisdom.institute.backend.base.domain.service.ResourceService;
import com.supwisdom.institute.backend.base.domain.service.RoleService;
import com.supwisdom.institute.backend.base.domain.service.RouteService;
import com.supwisdom.institute.backend.common.framework.vo.response.DefaultApiResponse;

@Api(value = "BaseAuthn", tags = { "BaseAuthn" }, description = "认证授权接口")
@Slf4j
@RestController
@RequestMapping("/v1/authn")
public class AuthnController {
  
  @Autowired
  private AccountService accountService;
  
  @Autowired
  private RoleService roleService;
  
  @Autowired
  private ApplicationService applicationService;

  @Autowired
  private PermissionService permissionService;

  @Autowired
  private ResourceService resourceService;

  @Autowired
  private RouteService routeService;

  @GetMapping(path = "/{username}/account", produces = MimeTypeUtils.APPLICATION_JSON_VALUE)
  @ResponseStatus(value = HttpStatus.OK)
  @ResponseBody
  public DefaultApiResponse<AuthnAccountResponseData> account(
      @PathVariable("username") String username) {

    if (username == null || username.length() == 0) {
      throw new RuntimeException("exception.get.username.must.not.empty");
    }

    Account account = accountService.selectByUsername(username);

    if (account == null) {
      throw new RuntimeException("exception.get.account.not.exist");
    }
    
    AuthnAccountResponseData data = AuthnAccountResponseData.of(account);

    return new DefaultApiResponse<AuthnAccountResponseData>(data);
  }
  
  @GetMapping(path = "/{username}/roles", produces = MimeTypeUtils.APPLICATION_JSON_VALUE)
  @ResponseStatus(value = HttpStatus.OK)
  @ResponseBody
  public DefaultApiResponse<AuthnAccountRolesResponseData> accountRoles(
      @PathVariable("username") String username) {

    if (username == null || username.length() == 0) {
      throw new RuntimeException("exception.get.username.must.not.empty");
    }

    Account account = accountService.selectByUsername(username);

    if (account == null) {
      throw new RuntimeException("exception.get.account.not.exist");
    }
    
    List<Role> roles = roleService.selectByUsername(username);
    
    AuthnAccountRolesResponseData data = AuthnAccountRolesResponseData.of(roles);

    return new DefaultApiResponse<AuthnAccountRolesResponseData>(data);
  }

  @GetMapping(path = "/{username}/applications", produces = MimeTypeUtils.APPLICATION_JSON_VALUE)
  @ResponseStatus(value = HttpStatus.OK)
  @ResponseBody
  public DefaultApiResponse<AuthnAccountPermissionsResponseData> accountApplications(
      @PathVariable("username") String username,
      @RequestParam(name = "applicationId", required = false) String applicationId) {

    if (username == null || username.length() == 0) {
      throw new RuntimeException("exception.get.username.must.not.empty");
    }

    Account account = accountService.selectByUsername(username);

    if (account == null) {
      throw new RuntimeException("exception.get.account.not.exist");
    }
    
    List<Permission> applications = permissionService.selectByUsername(username, null, Permission.TYPE_APPLICATION);
    
    AuthnAccountPermissionsResponseData data = AuthnAccountPermissionsResponseData.of(applications);

    return new DefaultApiResponse<AuthnAccountPermissionsResponseData>(data);
  }

  @GetMapping(path = "/{username}/menus", produces = MimeTypeUtils.APPLICATION_JSON_VALUE)
  @ResponseStatus(value = HttpStatus.OK)
  @ResponseBody
  public DefaultApiResponse<AuthnAccountPermissionsResponseData> accountMenus(
      @PathVariable("username") String username, 
      @RequestParam(name = "applicationId", required = false) String applicationId) {

    if (username == null || username.length() == 0) {
      throw new RuntimeException("exception.get.username.must.not.empty");
    }

    Account account = accountService.selectByUsername(username);

    if (account == null) {
      throw new RuntimeException("exception.get.account.not.exist");
    }
    
    List<Permission> menus = permissionService.selectByUsername(username, applicationId, Permission.TYPE_MENU);
    
    AuthnAccountPermissionsResponseData data = AuthnAccountPermissionsResponseData.of(menus);

    return new DefaultApiResponse<AuthnAccountPermissionsResponseData>(data);
  }

  @GetMapping(path = "/{username}/operations", produces = MimeTypeUtils.APPLICATION_JSON_VALUE)
  @ResponseStatus(value = HttpStatus.OK)
  @ResponseBody
  public DefaultApiResponse<AuthnAccountPermissionsResponseData> accountOperations(
      @PathVariable("username") String username, 
      @RequestParam(name = "applicationId", required = false) String applicationId) {

    if (username == null || username.length() == 0) {
      throw new RuntimeException("exception.get.username.must.not.empty");
    }

    Account account = accountService.selectByUsername(username);

    if (account == null) {
      throw new RuntimeException("exception.get.account.not.exist");
    }
    
    List<Permission> operations = permissionService.selectByUsername(username, applicationId, Permission.TYPE_OPERATION);
    
    AuthnAccountPermissionsResponseData data = AuthnAccountPermissionsResponseData.of(operations);

    return new DefaultApiResponse<AuthnAccountPermissionsResponseData>(data);
  }

  @GetMapping(path = "/{username}/resources", produces = MimeTypeUtils.APPLICATION_JSON_VALUE)
  @ResponseStatus(value = HttpStatus.OK)
  @ResponseBody
  public DefaultApiResponse<AuthnAccountResourcesResponseData> accountResources(
      @PathVariable("username") String username, 
      @RequestParam(name = "applicationId", required = false) String applicationId) {

    if (username == null || username.length() == 0) {
      throw new RuntimeException("exception.get.username.must.not.empty");
    }

    Account account = accountService.selectByUsername(username);

    if (account == null) {
      throw new RuntimeException("exception.get.account.not.exist");
    }
    
    List<Resource> resources = null;// FIXME: resourceService.selectByUsername(username, applicationId);
    
    AuthnAccountResourcesResponseData data = AuthnAccountResourcesResponseData.of(resources);

    return new DefaultApiResponse<AuthnAccountResourcesResponseData>(data);
  }
  
//  @GetMapping(path = "/resources", produces = MimeTypeUtils.APPLICATION_JSON_VALUE)
//  @ResponseStatus(value = HttpStatus.OK)
//  @ResponseBody
//  public DefaultApiResponse<AuthnResourceRoleListResponseData> applicationResources(
//      @RequestParam(name = "applicationId", required = false) String applicationId) {
//
//    List<ResourceRoleSet> resourceRoleSets = resourceService.selectByApplication(applicationId);
//    
//    AuthnResourceRoleListResponseData data = AuthnResourceRoleListResponseData.of(resourceRoleSets);
//
//    return new DefaultApiResponse<AuthnResourceRoleListResponseData>(data);
//  }


  @GetMapping(path = "/applications", produces = MimeTypeUtils.APPLICATION_JSON_VALUE)
  @ResponseStatus(value = HttpStatus.OK)
  @ResponseBody
  public DefaultApiResponse<AuthnApplicationsResponseData> applications() {
    
    Map<String, Object> mapBean = new HashMap<>();
    Map<String, String> orderBy = null;
    
    mapBean.put("status", "1");

    List<Application> applications = applicationService.selectList(mapBean, orderBy);
    
    AuthnApplicationsResponseData data = AuthnApplicationsResponseData.of(applications);

    return new DefaultApiResponse<AuthnApplicationsResponseData>(data);
  }
  
  @GetMapping(path = "/roles", produces = MimeTypeUtils.APPLICATION_JSON_VALUE)
  @ResponseStatus(value = HttpStatus.OK)
  @ResponseBody
  public DefaultApiResponse<AuthnRolesResponseData> roles() {
    
    Map<String, Object> mapBean = new HashMap<>();
    Map<String, String> orderBy = null;
    
    mapBean.put("status", "1");

    List<Role> roles = roleService.selectList(mapBean, orderBy);
    
    AuthnRolesResponseData data = AuthnRolesResponseData.of(roles);

    return new DefaultApiResponse<AuthnRolesResponseData>(data);
  }
  
  
  @GetMapping(path = "/permissionRoleSets", produces = MimeTypeUtils.APPLICATION_JSON_VALUE)
  @ResponseStatus(value = HttpStatus.OK)
  @ResponseBody
  public DefaultApiResponse<AuthnPermissionRoleListResponseData> permissionRoleSets(
      @RequestParam(name = "applicationId", required = false) String applicationId) {
    
    Map<String, Object> mapBean = new HashMap<>();
    
    mapBean.put("status", "1");
    if (applicationId != null && !applicationId.isEmpty()) {
      mapBean.put("applicationId", applicationId);
    }
    
    List<PermissionRoleSet> permissionRoleSets = permissionService.selectPermissionRoleSet(mapBean);
    
    AuthnPermissionRoleListResponseData data = AuthnPermissionRoleListResponseData.of(permissionRoleSets);

    return new DefaultApiResponse<AuthnPermissionRoleListResponseData>(data);
  }
  
  
  @GetMapping(path = "/resourceRoleSets", produces = MimeTypeUtils.APPLICATION_JSON_VALUE)
  @ResponseStatus(value = HttpStatus.OK)
  @ResponseBody
  public DefaultApiResponse<AuthnResourceRoleListResponseData> resourceRoleSets(
      @RequestParam(name = "applicationId", required = false) String applicationId) {
    
    Map<String, Object> mapBean = new HashMap<>();
    
    mapBean.put("status", "1");
    
    List<ResourceRoleSet> resourceRoleSets = resourceService.selectResourceRoleSet(mapBean);
    
    AuthnResourceRoleListResponseData data = AuthnResourceRoleListResponseData.of(resourceRoleSets);

    return new DefaultApiResponse<AuthnResourceRoleListResponseData>(data);
  }
  
  

  @GetMapping(path = "/routes", produces = MimeTypeUtils.APPLICATION_JSON_VALUE)
  @ResponseStatus(value = HttpStatus.OK)
  @ResponseBody
  public DefaultApiResponse<AuthnRoutesResponseData> routes() {
    
    Map<String, Object> mapBean = new HashMap<>();
    Map<String, String> orderBy = null;
    
    mapBean.put("status", "1");

    List<Route> routes = routeService.selectList(mapBean, orderBy);
    
    AuthnRoutesResponseData data = AuthnRoutesResponseData.of(routes);

    return new DefaultApiResponse<AuthnRoutesResponseData>(data);
  }
  

}
