package com.supwisdom.institute.backend.base.domain.entity;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;

import lombok.Getter;
import lombok.Setter;

import com.supwisdom.institute.backend.common.framework.entity.ABaseEntity;

@Entity
@Table(name = "TB_BASE_RESOURCE")
public class Resource extends ABaseEntity {

  /**
   * 
   */
  private static final long serialVersionUID = 4288268877209267453L;

  public static final String ACCESS_ANONYMOUS = "anonymous"; // 匿名访问anonymous
  public static final String ACCESS_AUTHENTICATE = "authenticate"; // 认证访问authenticate
  public static final String ACCESS_AUTHORIZE = "authorize"; // 授权访问authorize
  public static final String ACCESS_PERMIT_ALL = "permitAll"; // 允许所有permitAll
  public static final String ACCESS_DENY_ALL = "denyAll"; // 拒绝所有denyAll

  /**
   * 代码
   */
  @Getter
  @Setter
  @Column(name = "CODE")
  private String code;

  /**
   * 名称
   */
  @Getter
  @Setter
  @Column(name = "NAME")
  private String name;

  /**
   * 备注
   */
  @Getter
  @Setter
  @Column(name = "MEMO", nullable = true)
  private String memo;

  /**
   * 状态（1 启用，0 停用）
   */
  @Getter
  @Setter
  @Column(name = "STATUS")
  private String status;

  /**
   * 请求方式
   */
  @Getter
  @Setter
  @Column(name = "METHOD")
  private String method;

  /**
   * 请求路径
   */
  @Getter
  @Setter
  @Column(name = "PATH")
  private String path;

  /**
   * 访问规则（匿名访问anonymous、认证访问authenticate、授权访问authorize、允许所有permitAll、拒绝所有denyAll）
   */
  @Getter
  @Setter
  @Column(name = "ACCESS")
  private String access;

}
