package com.supwisdom.institute.backend.base.domain.repo;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;

import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Repository;
import org.springframework.util.StringUtils;

import com.supwisdom.institute.backend.base.domain.entity.Route;
import com.supwisdom.institute.backend.common.framework.repo.BaseJpaRepository;
import com.supwisdom.institute.backend.common.util.MapBeanUtils;

@Repository
public interface RouteRepository extends BaseJpaRepository<Route> {
  
  @Override
  public default Specification<Route> convertToSpec(Map<String, Object> mapBean) {
    
    Specification<Route> spec = new Specification<Route>() {

      /**
       * 
       */
      private static final long serialVersionUID = 9131799274128286026L;

      @Override
      public Predicate toPredicate(Root<Route> root, CriteriaQuery<?> query, CriteriaBuilder criteriaBuilder) {
        List<Predicate> predicates = new ArrayList<>();
        
        if (mapBean != null) {

          if (MapBeanUtils.getBoolean(mapBean, "deleted") != null) {
            predicates.add(criteriaBuilder.equal(root.get("deleted"), MapBeanUtils.getBoolean(mapBean, "deleted")));
          }

          if (!StringUtils.isEmpty(MapBeanUtils.getString(mapBean, "code"))) {
            predicates.add(criteriaBuilder.like(root.get("code"), "%" + MapBeanUtils.getString(mapBean, "code") + "%"));
          }
          if (!StringUtils.isEmpty(MapBeanUtils.getString(mapBean, "name"))) {
            predicates.add(criteriaBuilder.like(root.get("name"), "%" + MapBeanUtils.getString(mapBean, "name") + "%"));
          }
          
          if (!StringUtils.isEmpty(MapBeanUtils.getString(mapBean, "status"))) {
            predicates.add(criteriaBuilder.equal(root.get("status"), MapBeanUtils.getString(mapBean, "status")));
          }

          if (!StringUtils.isEmpty(MapBeanUtils.getString(mapBean, "url"))) {
            predicates.add(criteriaBuilder.like(root.get("url"), "%" + MapBeanUtils.getString(mapBean, "url") + "%"));
          }
          
          List<Predicate> predicatesKeyword = new ArrayList<>();
          if (!StringUtils.isEmpty(MapBeanUtils.getString(mapBean, "keyword"))) {
            predicatesKeyword.add(criteriaBuilder.like(root.get("code"), "%" + MapBeanUtils.getString(mapBean, "keyword") + "%"));
            predicatesKeyword.add(criteriaBuilder.like(root.get("name"), "%" + MapBeanUtils.getString(mapBean, "keyword") + "%"));
            predicatesKeyword.add(criteriaBuilder.like(root.get("memo"), "%" + MapBeanUtils.getString(mapBean, "keyword") + "%"));
            
            predicates.add(criteriaBuilder.or(predicatesKeyword.toArray(new Predicate[predicatesKeyword.size()])));
          }
        }
        
        return criteriaBuilder.and(predicates.toArray(new Predicate[predicates.size()]));
      }
      
    };
    
    return spec;
  }

}
