package com.supwisdom.institute.backend.admin.bff.api.v1.remote.base.v1.authn;

import org.springframework.stereotype.Component;

import com.alibaba.fastjson.JSONObject;
import com.supwisdom.institute.backend.admin.bff.api.v1.remote.exception.FallbackError;

import feign.hystrix.FallbackFactory;

@Component
public class AuthnRemoteFallbackFactory implements FallbackFactory<AuthnRemoteFeignClient> {

  @Override
  public AuthnRemoteFeignClient create(Throwable cause) {
    return new AuthnRemoteFeignClient() {

      @Override
      public JSONObject account(String username) {
        if (cause != null) {
          cause.printStackTrace();
        }
        return FallbackError.defaultErrorJson(cause);
      }

      @Override
      public JSONObject roles(String username) {
        if (cause != null) {
          cause.printStackTrace();
        }
        return FallbackError.defaultErrorJson(cause);
      }

      @Override
      public JSONObject applications(String username, String applicationId) {
        if (cause != null) {
          cause.printStackTrace();
        }
        return FallbackError.defaultErrorJson(cause);
      }

      @Override
      public JSONObject menus(String username, String applicationId) {
        if (cause != null) {
          cause.printStackTrace();
        }
        return FallbackError.defaultErrorJson(cause);
      }

      @Override
      public JSONObject operations(String username, String applicationId) {
        if (cause != null) {
          cause.printStackTrace();
        }
        return FallbackError.defaultErrorJson(cause);
      }

      @Override
      public JSONObject resources(String username, String applicationId) {
        if (cause != null) {
          cause.printStackTrace();
        }
        return FallbackError.defaultErrorJson(cause);
      }
      

      @Override
      public JSONObject applications() {
        if (cause != null) {
          cause.printStackTrace();
        }
        return FallbackError.defaultErrorJson(cause);
      }

      @Override
      public JSONObject roles() {
        if (cause != null) {
          cause.printStackTrace();
        }
        return FallbackError.defaultErrorJson(cause);
      }

      @Override
      public JSONObject permissionRoleSets(String applicationId) {
        if (cause != null) {
          cause.printStackTrace();
        }
        return FallbackError.defaultErrorJson(cause);
      }

      @Override
      public JSONObject resourceRoleSets(String applicationId) {
        if (cause != null) {
          cause.printStackTrace();
        }
        return FallbackError.defaultErrorJson(cause);
      }
      
    };
  }

}
