package com.supwisdom.institute.backend.admin.aggr.apis.remote.base.configuration;

import org.apache.http.conn.HttpClientConnectionManager;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.cloud.commons.httpclient.ApacheHttpClientFactory;
import org.springframework.context.annotation.Bean;

import com.supwisdom.institute.backend.common.core.feign.FeignClientBuilder;

import feign.Client;

public class BaseFeignClientConfiguration {

  @Bean
  public Client feignClient(
      @Value("${sw-backend-base-api.client-auth.enabled:false}") boolean enabled,
      @Value("${sw-backend-base-api.client-auth.key-password:}") String keyPassword,
      @Value("${sw-backend-base-api.client-auth.key-store:}") String keyStore,
      @Value("${sw-backend-base-api.client-auth.key-store-password:}") String keyStorePassword,
      @Value("${sw-backend-base-api.client-auth.trust-store:}") String trustStore,
      @Value("${sw-backend-base-api.client-auth.trust-store-password:}") String trustStorePassword,
      ApacheHttpClientFactory httpClientFactory,
      HttpClientConnectionManager httpClientConnectionManager) {
    
    return FeignClientBuilder.builder()
        .enabled(enabled)
        .keyPassword(keyPassword)
        .keyStore(keyStore)
        .keyStorePassword(keyStorePassword)
        .trustStore(trustStore)
        .trustStorePassword(trustStorePassword)
        .build()
        .apacheHttpClient(httpClientFactory, httpClientConnectionManager);
  }

}
