package com.supwisdom.institute.backend.admin.aggr.apis.remote.biz.v1.admin;

import org.springframework.stereotype.Component;

import com.alibaba.fastjson.JSONObject;
import com.supwisdom.institute.backend.admin.aggr.apis.model.biz.Biz;
import com.supwisdom.institute.backend.admin.aggr.apis.remote.exception.FallbackError;

import feign.hystrix.FallbackFactory;

@Component
public class AdminBizRemoteFallbackFactory implements FallbackFactory<AdminBizRemoteFeignClient> {

  @Override
  public AdminBizRemoteFeignClient create(Throwable cause) {
    return new AdminBizRemoteFeignClient() {

      @Override
      public JSONObject query(boolean loadAll, int pageIndex, int pageSize) {
        if (cause != null) {
          cause.printStackTrace();
        }
        return FallbackError.defaultErrorJson(cause);
      }

      @Override
      public JSONObject load(String id) {
        if (cause != null) {
          cause.printStackTrace();
        }
        return FallbackError.defaultErrorJson(cause);
      }

      @Override
      public JSONObject create(Biz biz) {
        if (cause != null) {
          cause.printStackTrace();
        }
        return FallbackError.defaultErrorJson(cause);
      }

      @Override
      public JSONObject update(String id, Biz biz) {
        if (cause != null) {
          cause.printStackTrace();
        }
        return FallbackError.defaultErrorJson(cause);
      }

      @Override
      public JSONObject delete(String id) {
        if (cause != null) {
          cause.printStackTrace();
        }
        return FallbackError.defaultErrorJson(cause);
      }
      
    };
  }

}
