package com.supwisdom.institute.backend.common.framework.vo.response;

import com.supwisdom.institute.backend.common.framework.vo.response.data.IApiResponseData;

public class DefaultApiResponse<T extends IApiResponseData> extends AbstractApiResponse<T> {

  /**
   * 
   */
  private static final long serialVersionUID = 4380576799912565681L;

  protected T data;

  @Override
  public T getData() {
    return data;
  }

  public DefaultApiResponse(T data) {
    this(0, null, data);
  }

  public DefaultApiResponse(int code, String message, T data) {
    super.code = code;
    super.message = message;
    
    this.data = data;
  }

  public static <T extends IApiResponseData> DefaultApiResponse<T> build(T data) {
    DefaultApiResponse<T> defaultApiResponse = new DefaultApiResponse<T>(data);

    return defaultApiResponse;
  }

}
