package com.supwisdom.institute.backend.thirdparty.agent;

import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.context.annotation.Bean;
import org.springframework.scheduling.annotation.EnableScheduling;
import org.springframework.web.cors.CorsConfiguration;
import org.springframework.web.cors.UrlBasedCorsConfigurationSource;
import org.springframework.web.filter.CorsFilter;

import com.supwisdom.institute.backend.common.core.transmit.annotation.EnableSimpleUserTransmit;
import com.supwisdom.institute.backend.common.framework.exception.EnableCustomExceptionHandler;

@SpringBootApplication

@EnableScheduling

@EnableSimpleUserTransmit
@EnableCustomExceptionHandler
public class Application {

  public static void main(String[] args) {
    SpringApplication.run(Application.class, args);
  }
  
  @Bean
  public CorsFilter corsFilter() {
    final CorsConfiguration config = new CorsConfiguration();
    // config.setAllowCredentials(true);
    config.addAllowedOrigin("*");
    config.addAllowedHeader("*");
    config.addAllowedMethod("*");

    final UrlBasedCorsConfigurationSource source = new UrlBasedCorsConfigurationSource();
    source.registerCorsConfiguration("/v2/api-docs", config);

    return new CorsFilter(source);
  }

}
