package com.supwisdom.institute.backend.thirdparty.poa;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.Map;

import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpHeaders;
import org.apache.http.HttpResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

import com.alibaba.fastjson.JSONObject;
import com.supwisdom.institute.backend.common.core.distributedlock.DistributedLockHandler;

import lombok.extern.slf4j.Slf4j;

@Slf4j
@Component
public class PoaUtil {
  
  public static void main(String[] args) {
    
    PoaUtil.poaServerUrl = "https://poa.supwisdom.com";
//    PoaUtil.clientId = "nV8US9uAdFQ0ovuYpFOloXtFkME=";
//    PoaUtil.clientSecret = "dDgZAzuNnOjfsbm8iDohyVCXBU1GwImeMsmkJzjyGh8=";
//    PoaUtil.scope = "user:v1:readUser,user:v1:readOrganization,user:v1:readGroup,user:v1:readLabel,authz:v1:readRole";
    
    PoaUtil.clientId = "RYMmw6ViBOKN0YXyDOtuUc3KHtU=";
    PoaUtil.clientSecret = "LLIkEPSzQO5ayjc_rRzdaWG87sz4ofkJwK9UtmAzv1U=";
    PoaUtil.scope = "user:v1:readUser,user:v1:readOrganization,user:v1:readGroup,user:v1:readLabel";
    
    //JSONObject accessTokenObject = PoaUtil.getAccessToken("https://poa.supwisdom.com", "tikgr8E6vfcGDXVSG5Vs-00XJoQ=", "wZugRIydkt9lQqJyi7lco-x8wZyyreb41WC_ioj8g-I=", "personalSecurityCenterSa:v1:admin");
    JSONObject accessTokenObject = PoaUtil.getAccessTokenObject();
    System.out.println(accessTokenObject.toJSONString());
    
    String accessToken = accessTokenObject.getString("access_token");
    PoaUtil.accessToken = accessToken;
    
    for(int i=0;i<100;i++) {
      new Thread(new Runnable() {

        @Override
        public void run() {
          JSONObject jsonObject = PoaUtil.loadUserInfoByAccountName("https://poa.supwisdom.com/apis/user/v1", "smartadmin");
          System.out.println(":::"+jsonObject.toJSONString());
        }
        
      }).start();;
      
      
    }
  }
  
  
  @Autowired(required = false)
  private DistributedLockHandler distributedLockHandler;
  
  //每隔 3000 秒执行一次
  @Scheduled(fixedRate = 3000000)
  public void refresh() {
    if (distributedLockHandler == null) {
      PoaUtil.clearAccessToken();
      
      try {
        JSONObject accessTokenObject = PoaUtil.getAccessTokenObject();
        if (PoaUtil.saveAccessToken(accessTokenObject)) {
          return;
        }
        
        try {
          Thread.sleep(500L);
        } catch (InterruptedException e) {
          e.printStackTrace();
        }
        log.debug("AccessTokenRefresh.refresh retry");
        
        refresh();
      } finally {
        
      }
    }
    
    final String LOCK_KEY = "poa:ACCESS_TOKEN_REFRESH:LOCK";
    
    boolean lock = distributedLockHandler.lock(LOCK_KEY, 5000L);  log.debug("AccessTokenRefresh.refresh lock: {}", lock);
    if(!lock) {
      return;
    }

    PoaUtil.clearAccessToken();

    try {
      JSONObject accessTokenObject = PoaUtil.getAccessTokenObject();
      
      if (PoaUtil.saveAccessToken(accessTokenObject)) {
        return;
      }
      
      // 如果 token 获取失败，则 先释放锁，随后再次尝试获取
      boolean releaseLock = distributedLockHandler.releaseLock(LOCK_KEY);  log.debug("AccessTokenRefresh.refresh releaseLock: {}", releaseLock);
      
      try {
        Thread.sleep(500L);
      } catch (InterruptedException e) {
        e.printStackTrace();
      }
      log.debug("AccessTokenRefresh.refresh retry");
      
      refresh();
      
    } finally {
      boolean releaseLock = distributedLockHandler.releaseLock(LOCK_KEY);  log.debug("AccessTokenRefresh.refresh finally releaseLock: {}", releaseLock);
    }
    
  }

  
  private static String accessToken = null;
  
  
  private static String poaServerUrl;

  private static String clientId;

  private static String clientSecret;

  private static String scope;
  
  private static StringRedisTemplate stringRedisTemplate;

  @Value("${poa.server.url}")
  public void setPoaServerUrl(String poaServerUrl) {
    PoaUtil.poaServerUrl = poaServerUrl;
  }
  @Value("${poa.client.id}")
  public void setClientId(String clientId) {
    PoaUtil.clientId = clientId;
  }
  @Value("${poa.client.secret}")
  public void setClientSecret(String clientSecret) {
    PoaUtil.clientSecret = clientSecret;
  }
  @Value("${poa.scopes}")
  public void setScopes(String[] scopes) {
    PoaUtil.scope = StringUtils.join(scopes, ","); log.debug("{}", PoaUtil.scope);
  }
  
  @Autowired(required = false)
  public void setStringRedisTemplate(StringRedisTemplate stringRedisTemplate) {
    PoaUtil.stringRedisTemplate = stringRedisTemplate;
  }
  
  public static boolean saveAccessToken(JSONObject accessTokenObject) {
    
    if (accessTokenObject != null) {
      String accessToken = accessTokenObject.getString("access_token");
      Long expiresIn = accessTokenObject.getLong("expires_in");
      
      PoaUtil.accessToken = accessToken;
      
      if (stringRedisTemplate != null) {
        final String ACCESS_TOKEN_KEY = "poa:"+clientId+":ACCESS_TOKEN";
        RedisUtils.redisTemplate(stringRedisTemplate).setValue(ACCESS_TOKEN_KEY, expiresIn, accessToken);
      }
      
      return true;
    }
    
    return false;
  }
  
  public static void clearAccessToken() {
    PoaUtil.accessToken = null;

    if (stringRedisTemplate != null) {
      final String ACCESS_TOKEN_KEY = "poa:"+clientId+":ACCESS_TOKEN";
      RedisUtils.redisTemplate(stringRedisTemplate).expireValue(ACCESS_TOKEN_KEY);
    }
  }
  
  public static String getAccessToken() {
    if (PoaUtil.accessToken != null) {
      return PoaUtil.accessToken;
    }
    
    if (stringRedisTemplate != null) {
      final String ACCESS_TOKEN_KEY = "poa:"+clientId+":ACCESS_TOKEN";
      PoaUtil.accessToken = RedisUtils.redisTemplate(stringRedisTemplate).getValue(ACCESS_TOKEN_KEY);
    }
    
    return PoaUtil.accessToken;
  }
  
  public static JSONObject getAccessTokenObject() {
    
    String tokenUrl = poaServerUrl + "/oauth2/token";
    
    String grantType = "client_credentials";
    
    Map<String, Object> headers = new HashMap<String, Object>();
    headers.put("Content-Type", "application/x-www-form-urlencoded");
    
    String formData = String.format("grant_type=%s&client_id=%s&client_secret=%s&scope=%s", grantType, clientId, clientSecret, scope);
    //log.debug("Post formData [{}]", formData);

    int retry = 0;
    while(retry < 3) {
      
      HttpResponse httpResponse = null;
      try{
        httpResponse = HttpUtils.execute(tokenUrl, "POST", null, null, new HashMap<String, Object>(), headers, formData);
        /**
         * {
         *   "access_token": "0loVdVN4AqPIbStZmkvtkw==",
         *   "token_type": "bearer",
         *   "expires_in": 3600
         * }
         */
        
        /**
         * {
         *   "error": "invalid_client",
         *   "error_description": ""
         * }
         */
        
        JSONObject resultJsonObject = parseJSONObject(httpResponse);
        if (resultJsonObject != null) {
          if (!resultJsonObject.containsKey("error")) {
            return resultJsonObject;
          }
          
          log.error("Get access_token by [{}] from poa error: {}", clientId, resultJsonObject.getString("error"));
          break;
        }
        
        retry ++;
        Thread.sleep(retry * retry * 500L);
        log.debug("Retry {}", retry);
      } catch (Exception e) {
        // 未知异常时，重试
        log.error("Get access_token by [{}] from poa excption: ", clientId, e);
      } finally {
        HttpUtils.close(httpResponse);
      }

    }
    
    return null;
  }
  
  

  private static JSONObject parseJSONObject(HttpResponse httpResponse) {
    try {
      if (httpResponse != null) {
        StringBuilder entityStringBuilder = new StringBuilder();
  
        BufferedReader b = new BufferedReader(new InputStreamReader(httpResponse.getEntity().getContent(), "UTF-8"), 8*1024);
  
        String line=null;
        while ((line=b.readLine())!=null) {
          entityStringBuilder.append(line);
        }
        log.debug("Fetch response [{}]", entityStringBuilder.toString());
        
        JSONObject resultJsonObject = JSONObject.parseObject(entityStringBuilder.toString());
        
        return resultJsonObject;
      }
    } catch (UnsupportedEncodingException e) {
      e.printStackTrace();
    } catch (UnsupportedOperationException e) {
      e.printStackTrace();
    } catch (IOException e) {
      e.printStackTrace();
    }
    
    return null;
  }
  
  
  public static JSONObject loadUserInfoByAccountName(String baseUrl, String accountName) {
    
    String url = baseUrl + "/users/accountName/" + accountName;

    Map<String, Object> parameters = new HashMap<String, Object>();

    Map<String, Object> headers = new HashMap<String, Object>();
    headers.put(HttpHeaders.AUTHORIZATION, "Bearer "+PoaUtil.getAccessToken());
    log.debug("{}", headers);
    
    HttpResponse httpResponse = null;
    try {
      httpResponse = HttpUtils.execute(url, "GET", parameters, headers);
      
      JSONObject resultJsonObject = parseJSONObject(httpResponse);
      if (resultJsonObject != null) {
        if (!resultJsonObject.containsKey("error")) {
          // XXX: 根据API响应数据，须修改为 只返回实际的 data 数据
          return resultJsonObject;
        }
      }
    } finally {
      HttpUtils.close(httpResponse);
    }
    
    return null;
  }
  
  
  public static JSONObject loadAccountApplicationRoles(String baseUrl, String applicationId, String username) {
    
    String url = baseUrl + "/application/"+applicationId+"/account/"+username+"/roles";
    log.debug(url);
    
    Map<String, Object> parameters = new HashMap<String, Object>();
    log.debug("{}", parameters);

    Map<String, Object> headers = new HashMap<String, Object>();
    headers.put(HttpHeaders.AUTHORIZATION, "Bearer "+PoaUtil.getAccessToken());
    log.debug("{}", headers);
    
    HttpResponse httpResponse = null;
    try {
      httpResponse = HttpUtils.execute(url, "GET", parameters, headers);
    
      JSONObject resultJsonObject = parseJSONObject(httpResponse);
      if (resultJsonObject != null) {
        if (!resultJsonObject.containsKey("error")) {
          // XXX: 根据API响应数据，须修改为 只返回实际的 data 数据
          return resultJsonObject;
        }
      }
    } finally {
      HttpUtils.close(httpResponse);
    }
    
    return null;
  }
  
}
