package com.supwisdom.institute.backend.thirdparty.poa.api.v1.controller;

import java.util.List;

import io.swagger.annotations.Api;
import lombok.extern.slf4j.Slf4j;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.util.MimeTypeUtils;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;

import com.supwisdom.institute.backend.common.framework.vo.response.DefaultApiResponse;
import com.supwisdom.institute.backend.thirdparty.poa.api.v1.vo.response.RoleListResponseData;
import com.supwisdom.institute.backend.thirdparty.poa.model.Role;
import com.supwisdom.institute.backend.thirdparty.poa.service.AuthzService;

@Api(value = "AgentPoaAuthz", tags = { "AgentPoaAuthz" }, description = "POA授权服务代理接口")
@Slf4j
@RestController
@RequestMapping("/v1/poa/authz")
public class AuthzController {
  
  @Autowired
  private AuthzService authzService;

  @GetMapping(path = "roles/account/{username}", produces = MimeTypeUtils.APPLICATION_JSON_VALUE)
  @ResponseStatus(value = HttpStatus.OK)
  @ResponseBody
  public DefaultApiResponse<RoleListResponseData> loadAccountApplicationRoles(
      @PathVariable("username") String username) {
    
    if (username == null || username.length() == 0) {
      throw new RuntimeException("exception.get.username.must.not.empty");
    }
    
    List<Role> roles = authzService.loadAccountRoles(username);
    
    if (roles == null) {
      throw new RuntimeException("exception.get.account.not.exist");
    }
    
    RoleListResponseData data = RoleListResponseData.of(roles);

    return new DefaultApiResponse<RoleListResponseData>(data);
  }

}
