package com.supwisdom.institute.backend.thirdparty.poa.service;

import java.util.List;

import lombok.extern.slf4j.Slf4j;

import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.supwisdom.institute.backend.thirdparty.poa.PoaUtil;
import com.supwisdom.institute.backend.thirdparty.poa.model.Role;

@Slf4j
@Service
public class AuthzService {

  @Value("${user-authorization-service.applicationId}")
  private String applicationId;

  @Value("${user-authorization-service.server.url}")
  private String userAuthorizationServiceServerUrl;
  
  public List<Role> loadAccountRoles(String username) {

    JSONObject jsonObject = PoaUtil.loadAccountApplicationRoles(userAuthorizationServiceServerUrl, applicationId, username);
    if (jsonObject == null) {
      return null;
    }
    
    JSONObject data = jsonObject.getJSONObject("data");
    
    JSONArray roleArray = data.getJSONArray("roles");
    
    List<Role> roles = roleArray.toJavaList(Role.class);
    log.debug("{}", roles);
    
    return roles;
  }
}
