package com.supwisdom.institute.backend.zuul.agent.poa.remote.configuration;

import javax.net.ssl.SSLContext;

import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.ssl.SSLContextBuilder;
import org.apache.http.ssl.SSLContexts;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.HttpComponentsClientHttpRequestFactory;
import org.springframework.http.client.SimpleClientHttpRequestFactory;
import org.springframework.util.ResourceUtils;
import org.springframework.web.client.RestTemplate;

@Configuration
public class AgentPoaRestTemplateConfig {

  @Bean
  public ClientHttpRequestFactory simpleClientHttpRequestFactory(
      @Value("${sw-backend-agent-poa.client-auth.enabled:false}") boolean enabled,
      @Value("${sw-backend-agent-poa.client-auth.key-password:}") String keyPassword,
      @Value("${sw-backend-agent-poa.client-auth.key-store:}") String keyStore,
      @Value("${sw-backend-agent-poa.client-auth.key-store-password:}") String keyStorePassword,
      @Value("${sw-backend-agent-poa.client-auth.trust-store:}") String trustStore,
      @Value("${sw-backend-agent-poa.client-auth.trust-store-password:}") String trustStorePassword
  ) {
    if (!enabled) {
      SimpleClientHttpRequestFactory factory = new SimpleClientHttpRequestFactory();
      factory.setReadTimeout(5000);// 单位为ms
      factory.setConnectTimeout(5000);// 单位为ms
      return factory;
    }
    
    SSLContextBuilder sslContextBuilder = SSLContexts.custom();
    
    if (trustStore == null || trustStore.isEmpty()) {
    } else {
      try {
        sslContextBuilder
          .loadTrustMaterial(
              ResourceUtils.getFile(trustStore),
              trustStorePassword.toCharArray()
          );
      } catch (Exception e) {
        e.printStackTrace();
      }
    }
    
    if (keyStore == null || keyStore.isEmpty()) {
      SimpleClientHttpRequestFactory factory = new SimpleClientHttpRequestFactory();
      factory.setReadTimeout(5000);// 单位为ms
      factory.setConnectTimeout(5000);// 单位为ms
      return factory;
    } else {
      try {
        sslContextBuilder
          .loadKeyMaterial(
              ResourceUtils.getFile(keyStore),
              keyStorePassword.toCharArray(),
              keyPassword.toCharArray());
      } catch (Exception e) {
        e.printStackTrace();
      }
    }
    
    try {
      SSLContext sslContext = sslContextBuilder.build();
  
      SSLConnectionSocketFactory sslsf = new SSLConnectionSocketFactory(
          sslContext,
          SSLConnectionSocketFactory.getDefaultHostnameVerifier());
      
      CloseableHttpClient httpClient = HttpClients.custom()
          .setSSLSocketFactory(sslsf)
          .build();
      
      HttpComponentsClientHttpRequestFactory factory = new HttpComponentsClientHttpRequestFactory(httpClient);
      factory.setReadTimeout(5000);// 单位为ms
      factory.setConnectTimeout(5000);// 单位为ms
      return factory;
    } catch (Exception e) {
      e.printStackTrace();
    }
    
    SimpleClientHttpRequestFactory factory = new SimpleClientHttpRequestFactory();
    factory.setReadTimeout(5000);// 单位为ms
    factory.setConnectTimeout(5000);// 单位为ms
    return factory;
  }
  
  @Bean(name = "agentPoaRestTemplate")
  public RestTemplate agentPoaRestTemplate(ClientHttpRequestFactory requestFactory) {
    return new RestTemplate(requestFactory);
  }
  
}
