package com.supwisdom.institute.backend.zuul.agent.poa.remote.web.client;

import lombok.extern.slf4j.Slf4j;

import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;
import org.springframework.web.client.RestTemplate;

import com.alibaba.fastjson.JSONObject;

@Slf4j
@Component
public class AgentPoaRemoteClient {
  
  @Autowired
  private RestTemplate agentPoaRestTemplate;

  @Value(value = "${sw-backend-agent-poa.uri}/v1/poa")
  private String url;
  
  private JSONObject defaultErrorJson(Throwable cause) {
    JSONObject error = new JSONObject();
    
    error.put("code", -1);
    error.put("message", cause.getMessage());
    error.put("error", cause.getMessage());
    
    return error;
  }

  public JSONObject loadUserInfoByAccountName(String accountName) {
    try {
      final String path = "/user/users/accountName/{accountName}";
      final String url = this.url + StringUtils.replaceEach(path, new String[] {"{accountName}"}, new String[] {accountName});
      log.debug(url);
      
      return agentPoaRestTemplate.getForObject(url, JSONObject.class);
    } catch (Exception e) {
      //e.printStackTrace();
      
      return defaultErrorJson(e);
    }
  }

  public JSONObject loadAccountApplicationRoles(String username) {
    try {
      final String path = "/authz/roles/account/{username}";
      final String url = this.url + StringUtils.replaceEach(path, new String[] {"{username}"}, new String[] {username});
      log.debug(url);
      
      return agentPoaRestTemplate.getForObject(url, JSONObject.class);
    } catch (Exception e) {
      //e.printStackTrace();
      
      return defaultErrorJson(e);
    }
  }

}
