package com.supwisdom.institute.backend.zuul.configuration;

import javax.net.ssl.SSLContext;

import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.ssl.SSLContextBuilder;
import org.apache.http.ssl.SSLContexts;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.util.ResourceUtils;

import com.supwisdom.institute.backend.zuul.filters.pre.IdTokenPreFilter;

import lombok.extern.slf4j.Slf4j;

@Slf4j
@Configuration
public class ZuulConfiguration {

  @Bean
  public IdTokenPreFilter idTokenPreFilter() {
    log.debug("-----IdTokenPreFilter");
    return new IdTokenPreFilter();
  }
  
  @Bean
  public CloseableHttpClient httpClient(
      @Value("${zuul-httpclient.client-auth.enabled:false}") boolean enabled,
      @Value("${zuul-httpclient.client-auth.key-password:}") String keyPassword,
      @Value("${zuul-httpclient.client-auth.key-store:}") String keyStore,
      @Value("${zuul-httpclient.client-auth.key-store-password:}") String keyStorePassword) {
    
    if (!enabled) {
      return HttpClients.custom().build();
    }

    SSLContextBuilder sslContextBuilder = SSLContexts.custom();
    
    // 如果 服务端启用了 TLS 客户端验证，则需要指定 keyStore
    if (keyStore == null || keyStore.isEmpty()) {
    } else {
      try {
        sslContextBuilder
          .loadKeyMaterial(
              ResourceUtils.getFile(keyStore),
              keyStorePassword.toCharArray(),
              keyPassword.toCharArray());
      } catch (Exception e) {
        e.printStackTrace();
      }
    }

    try {
      SSLContext sslContext = sslContextBuilder.build();
      
      SSLConnectionSocketFactory sslsf = new SSLConnectionSocketFactory(
          sslContext,
          SSLConnectionSocketFactory.getDefaultHostnameVerifier());
      
      CloseableHttpClient httpClient = HttpClients.custom()
          .setSSLSocketFactory(sslsf)
          .build();
      
      return httpClient;
    } catch (Exception e) {
      e.printStackTrace();
    }
    
    return HttpClients.custom().build();
  }

}
