package com.supwisdom.institute.backend.zuul.filters.pre;

import com.netflix.zuul.ZuulFilter;
import com.netflix.zuul.context.RequestContext;
import com.netflix.zuul.exception.ZuulException;
import com.supwisdom.infras.security.authentication.JwtAuthenticationToken;

import lombok.extern.slf4j.Slf4j;

import static org.springframework.cloud.netflix.zuul.filters.support.FilterConstants.PRE_TYPE;

import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;

@Slf4j
public class IdTokenPreFilter extends ZuulFilter {

  @Override
  public boolean shouldFilter() {
    Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
    if (authentication == null) {
      return false;
    }
    
    if (authentication.isAuthenticated()) {
      return true;
    }
    
    return false;
  }

  @Override
  public Object run() throws ZuulException {
    RequestContext ctx = RequestContext.getCurrentContext();
    
    Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
    if (JwtAuthenticationToken.class.isInstance(authentication)) {
      JwtAuthenticationToken jwtAuthenticationToken = (JwtAuthenticationToken) authentication;
      
      String token = jwtAuthenticationToken.getToken();
      log.debug("token is {}", token);

      // ctx.addZuulRequestHeader("userToken", token);

      ctx.addZuulRequestHeader("X-FORWARD-GATEWAY", "personal-security-zuul");
      ctx.addZuulRequestHeader("X-FORWARD-ID-TOKEN", token);
      log.debug("set to zuul header[X-FORWARD-ID-TOKEN]: ok");
    }
    
    return null;
  }

  @Override
  public String filterType() {
    return PRE_TYPE;
  }

  @Override
  public int filterOrder() {
    return 100;
  }

}
