package com.supwisdom.institute.backend.zuul.security.core.userdetails;

import java.util.Collection;
import java.util.Map;

import org.springframework.security.core.GrantedAuthority;

import com.supwisdom.infras.security.core.userdetails.InfrasUser;

public class MyUser extends InfrasUser {

  /**
   * 
   */
  private static final long serialVersionUID = 3195151947212484499L;

  public MyUser(String username, String password, 
      Collection<? extends GrantedAuthority> authorities, 
      Map<String, Object> attributes) {
    this(username, password, true, true, true, true, authorities, attributes);
  }

  public MyUser(String username, String password, 
      boolean enabled, boolean accountNonExpired, boolean credentialsNonExpired, boolean accountNonLocked, 
      Collection<? extends GrantedAuthority> authorities, 
      Map<String, Object> attributes) {
    super(username, password, enabled, accountNonExpired, credentialsNonExpired, accountNonLocked, authorities, attributes);
  }
  
  public Object getAttribute(String key) {
    if (this.getAttributes() == null) {
      return null;
    }
    
    if (!this.getAttributes().containsKey(key)) {
      return null;
    }
    
    return this.getAttributes().get(key);
  }
  
}
