package com.supwisdom.institute.backend.zuul.security.core.userdetails;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import lombok.extern.slf4j.Slf4j;

import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.security.core.userdetails.UsernameNotFoundException;
import org.springframework.security.crypto.password.PasswordEncoder;

import com.supwisdom.institute.backend.zuul.agent.poa.model.Role;
import com.supwisdom.institute.backend.zuul.agent.poa.model.UserInfoModel;
import com.supwisdom.institute.backend.zuul.agent.poa.service.AuthzService;
import com.supwisdom.institute.backend.zuul.agent.poa.service.UserService;

@Slf4j
public class PoaUserDetailsService implements UserDetailsService {

  @Autowired
  PasswordEncoder passwordEncoder;
  
  @Autowired
  UserService userService;
  @Autowired
  AuthzService authzService;

  @Override
  public UserDetails loadUserByUsername(String username) throws UsernameNotFoundException {

    log.debug("PoaUserDetailsService.loadUserByUsername({})", username);
    
    MyUser myUser = loadUser(username);

    return myUser;
  }

  private MyUser loadUser(String username) {
    
    UserInfoModel userInfoModel = userService.loadUserInfoByAccountName(username);
    if (userInfoModel == null) {
      throw new UsernameNotFoundException(String.format("%s not found", username));
    }
    
    List<Role> roles = authzService.loadAccountApplicationRoles(username);
    
    List<GrantedAuthority> authorities = new ArrayList<GrantedAuthority>();
    for (Role role : roles) {
      authorities.add(new SimpleGrantedAuthority(role.getCode()));
    }
    
    Map<String, Object> attributes = new HashMap<String, Object>();
    attributes.put("accountId", userInfoModel.getId());
    attributes.put("accountName", userInfoModel.getAccountName());

    attributes.put("identityTypeId", userInfoModel.getIdentityTypeId());
    attributes.put("identityTypeCode", userInfoModel.getIdentityTypeCode());
    attributes.put("identityTypeName", userInfoModel.getIdentityTypeName());

    attributes.put("organizationId", userInfoModel.getOrganizationId());
    attributes.put("organizationCode", userInfoModel.getOrganizationCode());
    attributes.put("organizationName", userInfoModel.getOrganizationName());
    
    attributes.put("uid", userInfoModel.getUid());
    attributes.put("name", userInfoModel.getName());
    attributes.put("genderName", userInfoModel.getGenderName());
    attributes.put("nationName", userInfoModel.getNationName());
    attributes.put("countryName", userInfoModel.getCountryName());
    attributes.put("addressName", userInfoModel.getAddressName());

    attributes.put("imageUrl", userInfoModel.getImageUrl());

    MyUser myUser = new MyUser(userInfoModel.getAccountName(), passwordEncoder.encode(StringUtils.reverse(userInfoModel.getAccountName())), 
        authorities, attributes);
    log.debug("myUser is {}", myUser);

    return myUser;
  }
}
