package com.supwisdom.institute.backend.zuul.security.web.access;

import java.util.Collection;
import java.util.Iterator;

import org.springframework.security.access.AccessDecisionManager;
import org.springframework.security.access.AccessDeniedException;
import org.springframework.security.access.ConfigAttribute;
import org.springframework.security.authentication.InsufficientAuthenticationException;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.GrantedAuthority;

import lombok.extern.slf4j.Slf4j;

@Slf4j
public class MyAccessDecisionManager implements AccessDecisionManager {

  @Override
  public void decide(Authentication authentication, Object object, Collection<ConfigAttribute> configAttributes)
      throws AccessDeniedException, InsufficientAuthenticationException {

    if (null == configAttributes || configAttributes.size() <= 0) {
      return;
    }
    
    ConfigAttribute ca;
    String needRole;
    for (Iterator<ConfigAttribute> iter = configAttributes.iterator(); iter.hasNext();) {
      ca = iter.next();
      needRole = ca.getAttribute();
      
      if (needRole == null || needRole.isEmpty()) {
        continue;
      }
      
      if (needRole.startsWith("ACCESS_")) {
        String access = needRole.substring("ACCESS_".length()); log.debug("Access is {}", access);
        if ("anonymous".equals(access)) {
          if (authentication.isAuthenticated()) {
            throw new AccessDeniedException("no right");
          }
          
          return;
        } else if ("authenticate".equals(access)) {
          if (!authentication.isAuthenticated()) {
            throw new AccessDeniedException("no right");
          }
          
          return;
        } else if ("permitAll".equals(access)) {
          return;
        } else if ("denyAll".equals(access)) {
          throw new AccessDeniedException("no right");
        }
        
        throw new AccessDeniedException("no right");
      }
      
      for (GrantedAuthority ga : authentication.getAuthorities()) { // authentication 为在注释1 中循环添加到 GrantedAuthority 对象中的权限信息集合
        if (needRole.trim().equals(ga.getAuthority())) {
          return;
        }
      }
    }
    
    throw new AccessDeniedException("no right");
  }

  @Override
  public boolean supports(ConfigAttribute attribute) {
    return true;
  }

  @Override
  public boolean supports(Class<?> clazz) {
    return true;
  }

}
