package com.supwisdom.institute.backend.base.domain.service;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

import lombok.extern.slf4j.Slf4j;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.supwisdom.institute.backend.base.domain.entity.Permission;
import com.supwisdom.institute.backend.base.domain.model.PermissionTreeNode;
import com.supwisdom.institute.backend.base.domain.repo.PermissionRepository;
import com.supwisdom.institute.backend.common.framework.entity.EntityUtils;
import com.supwisdom.institute.backend.common.framework.service.ABaseService;

@Slf4j
@Service
public class PermissionService extends ABaseService<Permission, PermissionRepository> {
  
  @Override
  public PermissionRepository getRepo() {
    return permissionRepository;
  }

  @Autowired
  private PermissionRepository permissionRepository;

  public void deleteBatch(List<String> ids) {
    
    ids.stream().forEach(id -> {
      this.deleteById(id);
    });
  }
  
  private Permission selectApplicationPermission() {
    Permission permission = permissionRepository.selectById(Permission.APPLICATION_ID);
    
    return permission;
  }

  public PermissionTreeNode selectPermissionTree(Map<String, Object> mapBean) {
    
    Permission applicationPermission = this.selectApplicationPermission();
    
    Map<String, PermissionTreeNode> parentTreeNode = new LinkedHashMap<String, PermissionTreeNode>();
    
    PermissionTreeNode rootTreeNode = new PermissionTreeNode();
    rootTreeNode.setId(applicationPermission.getId());
    rootTreeNode.setCode(applicationPermission.getCode());
    rootTreeNode.setName(applicationPermission.getName());
    rootTreeNode.setChildren(new ArrayList<PermissionTreeNode>());
    
    parentTreeNode.put(rootTreeNode.getId(), rootTreeNode);

    List<Permission> permissions = permissionRepository.selectList(true, -1, -1, mapBean, null);
    for (Permission permission : permissions) {
      PermissionTreeNode treeNode = EntityUtils.copy(permission, new PermissionTreeNode());
      treeNode.setChildren(new ArrayList<PermissionTreeNode>());
      
      parentTreeNode.put(treeNode.getId(), treeNode);
    }
    
    for (PermissionTreeNode treeNode : parentTreeNode.values()) {
      if (!parentTreeNode.containsKey(treeNode.getParentId())) {
        continue;
      }
      
      parentTreeNode.get(treeNode.getParentId()).getChildren().add(treeNode);
    }
    
    return rootTreeNode;
  }

}
