package com.supwisdom.institute.backend.admin.bff.configuration;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.web.servlet.ServletListenerRegistrationBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.security.web.access.intercept.FilterInvocationSecurityMetadataSource;

import com.supwisdom.institute.backend.admin.bff.listener.MyFilterInvocationSecurityMetadataSourceRefreshListener;

@Configuration
public class ListenerConfig {
  
  @Autowired
  private FilterInvocationSecurityMetadataSource securityMetadataSource;
  
  @Bean
  public ServletListenerRegistrationBean<MyFilterInvocationSecurityMetadataSourceRefreshListener> serssionListenerBean(){
    MyFilterInvocationSecurityMetadataSourceRefreshListener listener = new MyFilterInvocationSecurityMetadataSourceRefreshListener();
    listener.setSecurityMetadataSource(securityMetadataSource);
    
    ServletListenerRegistrationBean<MyFilterInvocationSecurityMetadataSourceRefreshListener> refreshListener = 
        new ServletListenerRegistrationBean<MyFilterInvocationSecurityMetadataSourceRefreshListener>(listener);
    return refreshListener;
  }

}
