package com.supwisdom.institute.backend.zuul.agent.poa.service;

import java.util.List;

import lombok.extern.slf4j.Slf4j;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.supwisdom.institute.backend.zuul.agent.poa.model.Role;
import com.supwisdom.institute.backend.zuul.agent.poa.remote.web.client.AgentPoaRemoteClient;

@Slf4j
@Service
public class AuthzService {
  
  @Autowired
  private AgentPoaRemoteClient agentPoaRemoteClient;
  
  public List<Role> loadAccountApplicationRoles(String username) {

    JSONObject jsonObject = agentPoaRemoteClient.loadAccountApplicationRoles(username);
    if (jsonObject == null) {
      return null;
    }
    
    if (jsonObject.getIntValue("code") == 0) {
      JSONObject data = jsonObject.getJSONObject("data");
      
      JSONArray roleArray = data.getJSONArray("roles");
      
      List<Role> roles = roleArray.toJavaList(Role.class);
      log.debug("roles: [{}]", roles);
      
      return roles;
    }
    
    return null;
  }
}
