package com.supwisdom.institute.backend.zuul.authn.service;

import java.util.List;

import lombok.extern.slf4j.Slf4j;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.alibaba.fastjson.JSONObject;
import com.supwisdom.institute.backend.zuul.authn.model.Account;
import com.supwisdom.institute.backend.zuul.authn.model.ResourceRoleSet;
import com.supwisdom.institute.backend.zuul.authn.model.Role;
import com.supwisdom.institute.backend.zuul.authn.model.Route;
import com.supwisdom.institute.backend.zuul.authn.remote.web.client.AuthnRemoteClient;

@Slf4j
@Service
public class AuthnService {
  
  @Autowired
  private AuthnRemoteClient authnRemoteClient;
  
  public Account account(String username) {
    
    JSONObject jsonObject = authnRemoteClient.account(username);
    if (jsonObject == null) {
      return null;
    }
    log.debug("{}", jsonObject.toJSONString());
    
    if (jsonObject.getIntValue("code") == 0) {
      JSONObject data = jsonObject.getJSONObject("data");
      
      return data.toJavaObject(Account.class);
    }
    
    return null;
  }

  public List<Role> accountRoles(String username) {
    
    JSONObject jsonObject = authnRemoteClient.accountRoles(username);
    if (jsonObject == null) {
      return null;
    }
    log.debug("{}", jsonObject.toJSONString());
    
    if (jsonObject.getIntValue("code") == 0) {
      JSONObject data = jsonObject.getJSONObject("data");
      
      return data.getJSONArray("roles").toJavaList(Role.class);
    }
    
    return null;
  }

  public List<ResourceRoleSet> resourceRoleSets() {
    
    JSONObject jsonObject = authnRemoteClient.resourceRoleSets();
    if (jsonObject == null) {
      return null;
    }
    log.debug("{}", jsonObject.toJSONString());
    
    if (jsonObject.getIntValue("code") == 0) {
      JSONObject data = jsonObject.getJSONObject("data");
      
      return data.getJSONArray("resourceRoleSets").toJavaList(ResourceRoleSet.class);
    }
    
    return null;
  }

  public List<Route> routes() {
    
    JSONObject jsonObject = authnRemoteClient.routes();
    if (jsonObject == null) {
      return null;
    }
    log.debug("{}", jsonObject.toJSONString());
    
    if (jsonObject.getIntValue("code") == 0) {
      JSONObject data = jsonObject.getJSONObject("data");
      
      return data.getJSONArray("routes").toJavaList(Route.class);
    }
    
    return null;
  }

}
