package com.supwisdom.institute.backend.zuul.configuration;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.web.ServerProperties;
import org.springframework.cloud.netflix.zuul.filters.ZuulProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import com.supwisdom.institute.backend.zuul.route.RouteLocator;
import com.supwisdom.institute.backend.zuul.route.listener.RouteRefreshListener;

import lombok.extern.slf4j.Slf4j;

@Slf4j
//@Configuration
public class RouteConfiguration {

  @Autowired
  ServerProperties server;

  @Autowired
  ZuulProperties zuulProperties;

  @Bean
  public RouteLocator routeLocator() {
    RouteLocator routeLocator = new RouteLocator(this.server.getServlet().getServletPrefix(), this.zuulProperties);
    log.debug("RouteConfiguration routeLocator is {}", routeLocator);
    
    return routeLocator;
  }
  
  
  @Bean
  public RouteRefreshListener routeRefreshListener() {
    return new RouteRefreshListener();
  }

}
