package com.supwisdom.institute.backend.zuul.route;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cloud.netflix.zuul.filters.RefreshableRouteLocator;
import org.springframework.cloud.netflix.zuul.filters.SimpleRouteLocator;
import org.springframework.cloud.netflix.zuul.filters.ZuulProperties;
import org.springframework.cloud.netflix.zuul.filters.ZuulProperties.ZuulRoute;
import org.springframework.util.StringUtils;

import lombok.extern.slf4j.Slf4j;

@Slf4j
public class RouteLocator extends SimpleRouteLocator implements RefreshableRouteLocator {

  private ZuulProperties properties;

  public RouteLocator(String servletPath, ZuulProperties properties) {
    super(servletPath, properties);
    this.properties = properties;
  }
  
  private AtomicReference<Map<String, ZuulRoute>> routesFromAuthn = new AtomicReference<>();
  

  @Override
  public void refresh() {
    doRefresh();
  }
  
  @Override
  protected void doRefresh() {
    Map<String, ZuulProperties.ZuulRoute> routesMap = locateRoutesFromAuthn();
    if (routesMap == null || routesMap.isEmpty()) {
      log.debug("skip");
      return;
    }
    
    super.doRefresh();
  }
  
//  @Override
//  public Route getMatchingRoute(String path) {
//    return super.getMatchingRoute(path); 
//  }
  
  
  @Override
  protected Map<String, ZuulProperties.ZuulRoute> locateRoutes() {
    log.debug("locateRoutes");
    LinkedHashMap<String, ZuulProperties.ZuulRoute> routesMap = new LinkedHashMap<>();
    // 从application.properties中加载路由信息
    routesMap.putAll(super.locateRoutes());
    // 从db中加载路由信息
    routesMap.putAll(this.routesFromAuthn.get()); // locateRoutesFromAuthn()，防止多次请求后端
    // 优化一下配置
    LinkedHashMap<String, ZuulProperties.ZuulRoute> values = new LinkedHashMap<>();
    for (Map.Entry<String, ZuulProperties.ZuulRoute> entry : routesMap.entrySet()) {
      String path = entry.getKey();
      // Prepend with slash if not already present.
      
//      String verb = "GET";
//      int idx = path.indexOf(" ");
//      if (idx != -1) {
//        verb = path.substring(0, idx);
//        path = path.substring(idx + 1);
//      }

      if (!path.startsWith("/")) {
        path = "/" + path;
      }
      if (StringUtils.hasText(this.properties.getPrefix())) {
        path = this.properties.getPrefix() + path;
        if (!path.startsWith("/")) {
          path = "/" + path;
        }
      }

      //values.put(verb.toUpperCase() + " " + path, entry.getValue());
      values.put(path, entry.getValue());
    }
    
    return values;
  }

  private Map<String, ZuulProperties.ZuulRoute> locateRoutesFromAuthn() {
    Map<String, ZuulProperties.ZuulRoute> routes = new LinkedHashMap<>();

//    List<com.supwisdom.institute.personal.security.center.zuul.sa.authn.model.Route> routeList = authnService.routes();
//    if (routeList != null) {
//      for (com.supwisdom.institute.personal.security.center.zuul.sa.authn.model.Route r : routeList) {
//        String id = r.getId();
//        String path = r.getPathPrefix() + "/**";
//        String serviceId = null;
//        String url = r.getUrl();
//        boolean stripPrefix = r.getStripPrefix();
//        boolean retryable = true;
//        Set<String> sensitiveHeaders = null;
//  
//        log.debug(path + " = " + url);
//  
//        ZuulProperties.ZuulRoute zuulRoute = new ZuulProperties.ZuulRoute(id, path, serviceId, url, stripPrefix, retryable, sensitiveHeaders);
//        routes.put(zuulRoute.getPath(), zuulRoute);
//      }
//    }
    
    if (routes != null && !routes.isEmpty()) {
      this.routesFromAuthn.set(routes);
    }
    
    return routes;
  }

}
