package com.supwisdom.institute.backend.zuul.route.listener;

import java.util.Timer;
import java.util.TimerTask;

import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.cloud.netflix.zuul.RoutesRefreshedEvent;
import org.springframework.cloud.netflix.zuul.filters.RouteLocator;
import org.springframework.context.ApplicationEventPublisher;

public class RouteRefreshListener implements InitializingBean, DisposableBean {

  @Autowired
  ApplicationEventPublisher publisher;

  @Autowired
  RouteLocator routeLocator;

  @Value("${admin-center-zuul.route.refresh.delay:5}")
  private int delay = 5; // 启动后，延迟 5 秒
  @Value("${admin-center-zuul.route.refresh.period:120}")
  private int period = 120; // 定时，每隔 120 秒
  
  private Timer beanRefreshTimer;

  @Override
  public void destroy() throws Exception {
    if (beanRefreshTimer != null) {
      beanRefreshTimer.cancel();
    }
  }

  @Override
  public void afterPropertiesSet() throws Exception {
    refresh();
  }
  
  private void refresh() {
    beanRefreshTimer = new Timer("定时刷新路由信息", true);
    
    beanRefreshTimer.scheduleAtFixedRate(new TimerTask() {
      
      @Override
      public void run() {
        try {
          refreshRoute();
        } catch (Exception e) {
          
        }
      }
    }, 1000 * delay, 1000 * period);
  }

  public void refreshRoute() {
    RoutesRefreshedEvent routesRefreshedEvent = new RoutesRefreshedEvent(routeLocator);
    publisher.publishEvent(routesRefreshedEvent);
  }

}
