package com.supwisdom.institute.backend.zuul.security.core.userdetails;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.security.core.userdetails.UsernameNotFoundException;
import org.springframework.security.crypto.password.PasswordEncoder;

import lombok.extern.slf4j.Slf4j;

@Slf4j
public class InMemeryUserDetailsService implements UserDetailsService {

  @Autowired
  PasswordEncoder passwordEncoder;
  
  @Override
  public UserDetails loadUserByUsername(String username) throws UsernameNotFoundException {
    
    log.debug("InMemeryUserDetailsService.loadUserByUsername({})", username);
    
    List<GrantedAuthority> authorities = new ArrayList<GrantedAuthority>();
    authorities.add(new SimpleGrantedAuthority("ROLE_ADMIN"));
    authorities.add(new SimpleGrantedAuthority("administrator"));
    authorities.add(new SimpleGrantedAuthority("user"));

    Map<String, Object> attributes = new HashMap<String, Object>();
    
    MyUser myUser = new MyUser(username, passwordEncoder.encode(username), authorities, attributes);
    log.debug("myUser is {}", myUser);
    
    return myUser;
  }
  
}
