package com.supwisdom.institute.backend.zuul.security.core.userdetails;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.security.core.userdetails.UsernameNotFoundException;
import org.springframework.security.crypto.password.PasswordEncoder;

import com.supwisdom.institute.backend.zuul.authn.model.Account;
import com.supwisdom.institute.backend.zuul.authn.model.Role;
import com.supwisdom.institute.backend.zuul.security.core.userdetails.MyUser;
import com.supwisdom.institute.backend.zuul.authn.service.AuthnService;

import lombok.extern.slf4j.Slf4j;

@Slf4j
public class MyUserDetailsService implements UserDetailsService {
  
  @Autowired
  PasswordEncoder passwordEncoder;
  
  @Autowired
  private AuthnService authnAccountService;

  @Override
  public UserDetails loadUserByUsername(String username) throws UsernameNotFoundException { // TODO: 

    log.debug("MyUserDetailsService.loadUserByUsername({})", username);
    
    MyUser myUser = loadUser(username);

    return myUser;
  }


  private MyUser loadUser(String username) {

    Account account = authnAccountService.account(username);
    if (account == null) {
      throw new UsernameNotFoundException(String.format("%s not found", username));
    }
    
    List<Role> roles = authnAccountService.accountRoles(username);
    
    List<GrantedAuthority> authorities = new ArrayList<GrantedAuthority>();
    for (Role role : roles) {
      authorities.add(new SimpleGrantedAuthority(role.getCode()));
    }
    
    Map<String, Object> attributes = new HashMap<String, Object>();
    attributes.put("accountId", account.getId());
    attributes.put("accountName", account.getName());
    //attributes.put("accountMobile", account.getMobile());
    //attributes.put("accountEmail", account.getEmail());

    MyUser myUser = new MyUser(account.getUsername(), passwordEncoder.encode(account.getPassword()), 
        account.getEnabled(), account.getAccountNonExpired(), account.getCredentialsNonExpired(), account.getAccountNonLocked(), 
        authorities, attributes);
    log.debug("myUser is {}", myUser);

    return myUser;
  }

}
