package com.supwisdom.institute.backend.zuul.security.listener;

import java.util.Timer;
import java.util.TimerTask;

import javax.servlet.ServletContextEvent;

import org.springframework.beans.factory.annotation.Value;
import org.springframework.security.web.access.intercept.FilterInvocationSecurityMetadataSource;
import org.springframework.web.context.ContextLoaderListener;

import com.supwisdom.institute.backend.zuul.security.web.access.intercept.MyFilterInvocationSecurityMetadataSource;

import lombok.extern.slf4j.Slf4j;

@Slf4j
public class MyFilterInvocationSecurityMetadataSourceRefreshListener extends ContextLoaderListener {

  private FilterInvocationSecurityMetadataSource securityMetadataSource;
  public void setSecurityMetadataSource(FilterInvocationSecurityMetadataSource securityMetadataSource) {
    this.securityMetadataSource = securityMetadataSource;
  }

  private Timer timer = null;

  @Value("${admin-center-zuul.resource.refresh.delay:5}")
  private int delay = 5; // 启动后，延迟 5 秒
  @Value("${admin-center-zuul.resource.refresh.period:20}")
  private int period = 20; // 定时，每隔 20 秒

  @Override
  public void contextInitialized(ServletContextEvent event) {
    // super.contextInitialized(event);
    log.info("MyFilterInvocationSecurityMetadataSourceRefreshListener.contextInitialized");

    if (securityMetadataSource instanceof MyFilterInvocationSecurityMetadataSource) {
      timer = new Timer("定时刷新权限信息", true);

      timer.scheduleAtFixedRate(new TimerTask() {

        @Override
        public void run() {
          try {
            ((MyFilterInvocationSecurityMetadataSource) securityMetadataSource).refreshRequestMap();
          } catch (Exception e) {
            
          }
        }

      }, 1000 * delay, 1000 * period);

    }

  }

  @Override
  public void contextDestroyed(ServletContextEvent event) {
    // super.contextDestroyed(event);
    log.info("MyFilterInvocationSecurityMetadataSourceRefreshListener.contextDestroyed");

    if (timer != null) {
      timer.cancel();
    }
  }

}
