package com.supwisdom.institute.backend.zuul.security.web.access.intercept;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

import javax.servlet.http.HttpServletRequest;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.ConfigAttribute;
import org.springframework.security.access.SecurityConfig;
import org.springframework.security.web.FilterInvocation;
import org.springframework.security.web.access.intercept.FilterInvocationSecurityMetadataSource;
import org.springframework.security.web.util.matcher.AntPathRequestMatcher;
import org.springframework.security.web.util.matcher.RequestMatcher;

import lombok.extern.slf4j.Slf4j;

@Slf4j
public class MyFilterInvocationSecurityMetadataSource implements FilterInvocationSecurityMetadataSource {
  
  private Map<RequestMatcher, Collection<ConfigAttribute>> requestMap = null;

  public void refreshRequestMap() {
    
    log.info("MyFilterInvocationSecurityMetadataSource.refreshRequestMap");
    
    requestMap = null;
    loadRequestMap();
  }
  
  private void loadRequestMap() {
    synchronized (MyFilterInvocationSecurityMetadataSource.class) {

      if (requestMap == null) {
        requestMap = new LinkedHashMap<RequestMatcher, Collection<ConfigAttribute>>();
        
//        List<ResourceRoleSet> resourceRoleSets = authnService.resourceRoleSets();
//        if (resourceRoleSets != null) {
//          for (ResourceRoleSet resourceRoleSet : resourceRoleSets) {
//            String method = resourceRoleSet.getMethod();
//            String path = resourceRoleSet.getPath();
//            String access = resourceRoleSet.getAccess();
//            
//            final RequestMatcher requestMatcher = new AntPathRequestMatcher(path, method);
//            
//            Collection<ConfigAttribute> attributes = new ArrayList<ConfigAttribute>();
//            
//            if (access.equals(ResourceRoleSet.ACCESS_ANONYMOUS)) {
//              attributes.add(new SecurityConfig("ACCESS_"+ResourceRoleSet.ACCESS_ANONYMOUS));
//            } else if (access.equals(ResourceRoleSet.ACCESS_AUTHENTICATE)) {
//              attributes.add(new SecurityConfig("ACCESS_"+ResourceRoleSet.ACCESS_AUTHENTICATE));
//            } else if (access.equals(ResourceRoleSet.ACCESS_AUTHORIZE)) {
//              for (Role r : resourceRoleSet.getRoles()) {
//                ConfigAttribute ca = new SecurityConfig(r.getCode());
//                attributes.add(ca);
//              }
//            } else if (access.equals(ResourceRoleSet.ACCESS_PERMIT_ALL)) {
//              attributes.add(new SecurityConfig("ACCESS_"+ResourceRoleSet.ACCESS_PERMIT_ALL));
//            } else if (access.equals(ResourceRoleSet.ACCESS_DENY_ALL)) {
//              attributes.add(new SecurityConfig("ACCESS_"+ResourceRoleSet.ACCESS_DENY_ALL));
//            } else {
//              continue;
//            }
//            
//            requestMap.put(requestMatcher, attributes);
//          }
//        }
        
      }
      
    }
  }

  /**
   * 获取当前请求关联的所有角色code {@link SecurityConfig} 用于和用户拥有的角色code 进行比对
   */
  @Override
  public Collection<ConfigAttribute> getAttributes(Object object) throws IllegalArgumentException {

    if (requestMap == null) {
      loadRequestMap();
    }

    HttpServletRequest request = ((FilterInvocation) object).getHttpRequest();

    RequestMatcher requestMatcher;
    for (Iterator<RequestMatcher> iter = requestMap.keySet().iterator(); iter.hasNext();) {
      requestMatcher = iter.next();

      if (requestMatcher.matches(request)) {
        return requestMap.get(requestMatcher);
      }
    }

    return null;
  }

  @Override
  public Collection<ConfigAttribute> getAllConfigAttributes() {

    return null;
  }

  @Override
  public boolean supports(Class<?> clazz) {

    return true;
  }

}
