package com.supwisdom.institute.backend.zuul.security.web.access.intercept;

import java.io.IOException;
import java.util.HashSet;
import java.util.Set;

import javax.servlet.ServletException;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.AccessDecisionManager;
import org.springframework.security.access.SecurityMetadataSource;
import org.springframework.security.access.intercept.InterceptorStatusToken;
import org.springframework.security.web.FilterInvocation;
import org.springframework.security.web.access.intercept.FilterInvocationSecurityMetadataSource;

import com.supwisdom.infras.security.web.access.intercept.InfrasFilterSecurityInterceptor;

import lombok.extern.slf4j.Slf4j;

@Slf4j
public class MyFilterSecurityInterceptor extends InfrasFilterSecurityInterceptor {
  
  @Autowired
  private FilterInvocationSecurityMetadataSource securityMetadataSource;

  @Autowired
  public void setAccessDecisionManager(AccessDecisionManager accessDecisionManager) {

    super.setAccessDecisionManager(accessDecisionManager);
  }

  @Override
  public void invoke(FilterInvocation fi) throws IOException, ServletException {
    
    Set<String> noneSecurityUrl = new HashSet<String>();  // FIXME: 对无须访问控制的url，支持可配置
    noneSecurityUrl.add("/web/login");
    noneSecurityUrl.add("/web/logout");
    noneSecurityUrl.add("/web/index");

    if (fi.getRequest() != null) {
      String requestUrl = fi.getRequestUrl(); log.debug("MyFilterSecurityInterceptor invoke requestUrl: {}", requestUrl);
      if (noneSecurityUrl.contains(requestUrl)) {
        fi.getChain().doFilter(fi.getRequest(), fi.getResponse());
        return;
      }
    }

//    if (AuthenticationUtil.isAdministrator()) {
//      fi.getChain().doFilter(fi.getRequest(), fi.getResponse());
//      return;
//    }

    // fi里面有一个被拦截的url
    // 里面调用MyInvocationSecurityMetadataSource的getAttributes(Object object)这个方法获取fi对应的所有权限
    // 再调用MyAccessDecisionManager的decide方法来校验用户的权限是否足够
    InterceptorStatusToken token = super.beforeInvocation(fi);
    try {
      // 执行下一个拦截器
      fi.getChain().doFilter(fi.getRequest(), fi.getResponse());
    } finally {
      super.afterInvocation(token, null);
    }
  }

  @Override
  public Class<?> getSecureObjectClass() {

    return FilterInvocation.class;
  }

  @Override
  public SecurityMetadataSource obtainSecurityMetadataSource() {

    return this.securityMetadataSource;
  }
  
}
