package com.supwisdom.institute.base.transmit.zuul;

import org.apache.commons.codec.binary.Base64;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;

import com.alibaba.fastjson.JSONObject;
import com.netflix.zuul.ZuulFilter;
import com.netflix.zuul.context.RequestContext;
import com.netflix.zuul.exception.ZuulException;
import com.supwisdom.infras.security.authentication.converter.InfrasUserConverter;
import com.supwisdom.infras.security.core.userdetails.InfrasUser;
import com.supwisdom.institute.base.transmit.user.User;

import lombok.extern.slf4j.Slf4j;

@Slf4j
public class SimpleUserTransmitPreFilter extends ZuulFilter {
  
  @Autowired
  private InfrasUserConverter infrasUserConverter;

  @Override
  public boolean shouldFilter() {
    Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
    if (authentication == null) {
      return false;
    }
    
    if (authentication.isAuthenticated()) {
      return true;
    }
    
    return false;
  }

  @Override
  public Object run() throws ZuulException {
    RequestContext ctx = RequestContext.getCurrentContext();
    
    Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
    InfrasUser infrasUser = infrasUserConverter.convert(authentication);
    
    if (infrasUser != null) {
      try {
        User user = new User(infrasUser.getUsername(), infrasUser.getRoles(), infrasUser.getAttributes());
        
        String jsonUser = JSONObject.toJSONString(user);
        log.debug(jsonUser);
        
        //String headerValue = URLEncoder.encode(jsonUser,"UTF-8");
        String headerValue = Base64.encodeBase64URLSafeString(jsonUser.getBytes("UTF-8"));
        log.debug(headerValue);
        
        ctx.addZuulRequestHeader(User.KEY_USER_IN_HTTP_HEADER, headerValue);
        
        log.debug("User set to zuul header: ok");
      } catch (Exception e) {
        log.warn("User set to zuul header: error", e);
      }
    }
    
    return null;
  }

  @Override
  public String filterType() {
    return "pre";
  }

  @Override
  public int filterOrder() {
    return 9999;
  }

}
