package com.supwisdom.institute.backend.admin.bff.configuration;

import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import springfox.documentation.builders.ApiInfoBuilder;
import springfox.documentation.builders.PathSelectors;
import springfox.documentation.builders.RequestHandlerSelectors;
import springfox.documentation.service.ApiInfo;
import springfox.documentation.service.Contact;
import springfox.documentation.spi.DocumentationType;
import springfox.documentation.spring.web.plugins.Docket;
import springfox.documentation.swagger.web.UiConfiguration;
import springfox.documentation.swagger.web.UiConfigurationBuilder;
import springfox.documentation.swagger2.annotations.EnableSwagger2;

@Configuration
@EnableSwagger2
public class Swagger2Config {

  @Value("${swagger2.apis.basePackage:com.supwisdom.institute}")
  private String basePackage;

  @Bean
  public Docket createRestApi() {
    return new Docket(DocumentationType.SWAGGER_2)
        .apiInfo(apiInfo())
        .select()
        .apis(RequestHandlerSelectors.basePackage(basePackage))
        .paths(PathSelectors.any())
        .build()
        ;
  }

  private ApiInfo apiInfo() {
    Contact contact = new Contact("Backend Admin Aggregator API", "https://sw-backend-aggr.supwisdom.com/swagger-ui.html", ""); // name, url, email
    return new ApiInfoBuilder()
        .title("Backend Admin Aggregator APIs")
        .description("管理后台 - 聚合接口")
        .termsOfServiceUrl("http://www.supwisdom.com/")
        .contact(contact)
        .version("1.0")
        .build();
  }

  @Bean
  UiConfiguration uiConfig() {
    
    return UiConfigurationBuilder.builder().build();
    
//    return new UiConfiguration(null, // url
//        "none", // docExpansion => none | list
//        "alpha", // apiSorter => alpha
//        "schema", // defaultModelRendering => schema
//        UiConfiguration.Constants.DEFAULT_SUBMIT_METHODS,
//        false, // enableJsonEditor => true || false
//        true, // showRequestHeaders => true | false
//        60000L); // requestTimeout => in milliseconds, defaults to null
//    // (uses jquery xh timeout)
  }

}
