package com.supwisdom.institute.backend.common.util;

import java.text.ParseException;
import java.util.Date;

import org.apache.commons.lang3.time.DateFormatUtils;
import org.apache.commons.lang3.time.DateUtils;

public class DateUtil {
  
  public static void main(String[] args) {
    Date d0 = DateUtil.parseDate("2019-07-23 00:00:00", "yyyy-MM-dd HH:mm:ss");

    Date d1 = DateUtil.parseDate("2019-07-23 23:59:59", "yyyy-MM-dd HH:mm:ss");

    System.out.println(d0);
    System.out.println(d1);
    
    String s0 = DateUtil.formatDate(DateUtil.now(), "yyyyMMddHHmmss");
    System.out.println(s0);
  }
  
  public static Date parseDate(String source, String pattern) {
    
    try {
      Date d = DateUtils.parseDate(source, pattern);
      
      return d;
    } catch (ParseException e) {
      e.printStackTrace();
    }
    
    return null;
  }

  public static Date now() {
    return new Date();
  }
  
  
  public static String formatDate(Date date, String pattern) {
    return DateFormatUtils.format(date, pattern);
  }

}
