package com.supwisdom.institute.backend.base.api.v1.vo.admin.response;

import java.util.List;

import com.supwisdom.institute.backend.base.domain.entity.Permission;
import com.supwisdom.institute.backend.common.framework.entity.EntityUtils;
import com.supwisdom.institute.backend.common.framework.vo.response.data.IApiLoadResponseData;

import lombok.Getter;
import lombok.Setter;

/**
 * @author loie
 */
public class PermissionLoadResponseData extends Permission implements IApiLoadResponseData {

  /**
   * 
   */
  private static final long serialVersionUID = -2692036336252091453L;

  @Getter
  @Setter
  private String id;

  @Getter
  @Setter
  private List<String> resourceIds;

  
  private PermissionLoadResponseData() {

  }

  public static PermissionLoadResponseData of(Permission entity, List<String> resourceIds) {
    PermissionLoadResponseData data = new PermissionLoadResponseData();

    EntityUtils.copy(entity, data);
    data.setResourceIds(resourceIds);
    
    return data;
  }

}
