package com.supwisdom.institute.backend.common.core.transmit.filter;

import java.io.IOException;

import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;

import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang3.StringUtils;

import com.alibaba.fastjson.JSON;
import com.supwisdom.institute.backend.common.core.transmit.user.User;
import com.supwisdom.institute.backend.common.core.transmit.user.UserContext;

import lombok.extern.slf4j.Slf4j;

@Slf4j
public class SimpleUserTransmitFilter implements Filter {

  @Override
  public void init(FilterConfig filterConfig) throws ServletException {
    
  }

  @Override
  public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
    HttpServletRequest request = (HttpServletRequest) servletRequest;
    
    String headerValue = request.getHeader(UserContext.KEY_USER_IN_HTTP_HEADER);
    log.debug("Header {} is: {}", UserContext.KEY_USER_IN_HTTP_HEADER, headerValue);
    if (StringUtils.isNotBlank(headerValue)) {
      try {
        //String jsonUser = URLDecoder.decode(headerValue,"UTF-8");
        String jsonUser = new String(Base64.decodeBase64(headerValue), "UTF-8");
        log.debug("jsonUser is: {}", jsonUser);
        
        User user = JSON.parseObject(jsonUser, User.class);
        log.debug("User is: {}", user);
        
        UserContext.setUser(user);
        log.debug("User get from header: ok");
      } catch (Exception e) {
        log.warn("User get from header: error", e);
      }
    }
    
    filterChain.doFilter(servletRequest, servletResponse);
  }

  @Override
  public void destroy() {
    
  }

}
