package com.supwisdom.institute.backend.common.framework.exception;

import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestControllerAdvice;

@RestControllerAdvice
public class GlobalExceptionHandler {
  
  @ResponseStatus(value = HttpStatus.INTERNAL_SERVER_ERROR)
  @ExceptionHandler({Exception.class})
  public ErrorResponse DefaultExceptionHandler(Exception e) {
    
    ErrorResponse error = ErrorResponse.of(BaseException.DEFAULT_CODE, e.getMessage());
    
    return error;
  }
  
  
  @ResponseStatus(value = HttpStatus.INTERNAL_SERVER_ERROR)
  @ExceptionHandler({BaseException.class})
  public ErrorResponse BaseExceptionHandler(BaseException e) {
    
    ErrorResponse error = ErrorResponse.of(e.getCode(), e.getMessage());
    
    return error;
  }
  
}
