package com.supwisdom.institute.backend.common.framework.service;

import java.util.Map;

import org.springframework.data.domain.Page;

import com.supwisdom.institute.backend.common.framework.entity.ABaseEntity;
import com.supwisdom.institute.backend.common.framework.repo.BaseJpaRepository;

public abstract class ABaseService<E extends ABaseEntity, REPO extends BaseJpaRepository<E>> {
  
  public abstract REPO getRepo();
  
  public Page<E> selectPageList(boolean loadAll, int pageIndex, int pageSize, Map<String, Object> mapBean, Map<String, String> orderBy) {
    
    return getRepo().selectPageList(loadAll, pageIndex, pageSize, mapBean, orderBy);
  }
  
  public E selectById(String id) {
    
    return getRepo().selectById(id);
  }
  
  public E insert(E entity) {
    
    return getRepo().insert(entity);
  }
  
  public E update(E entity) {
    
    E ret = getRepo().update(entity);
    getRepo().flush();
    
    return ret;
  }
  
  public void deleteById(String id) {
    
    getRepo().deleteById(id);
  }

}
