package com.supwisdom.institute.backend.common.core.feign;

import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;

import lombok.extern.slf4j.Slf4j;

import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.ssl.SSLContextBuilder;
import org.apache.http.ssl.SSLContexts;
import org.springframework.util.ResourceUtils;

import feign.Client;
import feign.httpclient.ApacheHttpClient;

@Slf4j
@lombok.Builder
public class FeignClientBuilder {
  
  private final boolean enabled;
  
  private String keyPassword;
  private String keyStore;
  private String keyStorePassword;
  private String trustStore;
  private String trustStorePassword;
  
  public Client client() {

    if (!enabled) {
      return new ApacheHttpClient();
    }
    
    if (keyStore == null || keyStore.isEmpty()) {
      return new ApacheHttpClient();
    } else {
      try {
        SSLContextBuilder sslContextBuilder = SSLContexts.custom();
        if (trustStore == null || trustStore.isEmpty()) {
        } else {
          sslContextBuilder
//            .loadTrustMaterial(TrustAllStrategy.INSTANCE)
            .loadTrustMaterial(
                ResourceUtils.getFile(trustStore),
                trustStorePassword.toCharArray()
            );
        }
        
        sslContextBuilder
          .loadKeyMaterial(
              ResourceUtils.getFile(keyStore),
              keyStorePassword.toCharArray(),
              keyPassword.toCharArray());
        
        SSLContext sslContext = sslContextBuilder.build();
        
        SSLSocketFactory sslSocketFactory = sslContext.getSocketFactory();

        Client trustSSLSockets = new Client.Default(sslSocketFactory, new NoopHostnameVerifier());  // FIXME: feign Client
        log.info("feignClient load with ssl.");
        return trustSSLSockets;
      } catch (Exception e) {
        e.printStackTrace();
      }
    }
    
    return new ApacheHttpClient();
  }

}
