package com.supwisdom.institute.backend.common.core.transmit.feign;

import java.net.URLDecoder;

import lombok.extern.slf4j.Slf4j;

import com.alibaba.fastjson.JSONObject;
import com.supwisdom.institute.backend.common.core.transmit.user.User;
import com.supwisdom.institute.backend.common.core.transmit.user.UserContext;

import feign.RequestInterceptor;
import feign.RequestTemplate;

@Slf4j
public class SimpleUserTransmitRequestInterceptor implements RequestInterceptor {

  @Override
  public void apply(RequestTemplate template) {
    User user = UserContext.getUser();
    if (user != null) {
      try {
        String jsonUser = JSONObject.toJSONString(user);
        String headerValue = new String(URLDecoder.decode(jsonUser,"UTF-8"));
        template.header(UserContext.KEY_USER_IN_HTTP_HEADER, headerValue);
      } catch (Exception e) {
        log.warn("User set error", e);
      }
    }
  }

}
