

CREATE TABLE `TB_BASE_APPLICATION` (
  `ID` VARCHAR(100) NOT NULL COMMENT '',
  `COMPANY_ID` VARCHAR(100) COMMENT 'CompanyID',
  `DELETED` INT(1) COMMENT '是否删除',
  `ADD_ACCOUNT` VARCHAR(100) COMMENT '创建人',
  `ADD_TIME` DATETIME COMMENT '创建时间',
  `EDIT_ACCOUNT` VARCHAR(100) COMMENT '修改人',
  `EDIT_TIME` DATETIME COMMENT '修改时间',
  `DELETE_ACCOUNT` VARCHAR(100) COMMENT '删除人',
  `DELETE_TIME` DATETIME COMMENT '删除时间',

  `CODE` VARCHAR(200) NOT NULL COMMENT '代码',
  `NAME` VARCHAR(200) NOT NULL COMMENT '名称',
  `MEMO` VARCHAR(500) COMMENT '备注',
  `STATUS` VARCHAR(10) NOT NULL COMMENT '状态（1 启用，0 停用）',

  `URL` VARCHAR(500) COMMENT '系统地址',

  `SPI_URL_PREFIX` VARCHAR(500) COMMENT '同步接口服务（用于同步菜单）',

  PRIMARY KEY (`ID`),
  UNIQUE KEY `UQ_CODE` (`COMPANY_ID`,`CODE`)
)
COMMENT = '系统信息表';


insert into TB_BASE_APPLICATION (ID, DELETED, CODE, NAME, STATUS) 
values ('1', 0, 'admin', '树维管理后台', '1');

commit;



CREATE TABLE `TB_BASE_ROUTE` (
  `ID` VARCHAR(100) NOT NULL COMMENT '',
  `COMPANY_ID` VARCHAR(100) COMMENT 'CompanyID',
  `DELETED` INT(1) COMMENT '是否删除',
  `ADD_ACCOUNT` VARCHAR(100) COMMENT '创建人',
  `ADD_TIME` DATETIME COMMENT '创建时间',
  `EDIT_ACCOUNT` VARCHAR(100) COMMENT '修改人',
  `EDIT_TIME` DATETIME COMMENT '修改时间',
  `DELETE_ACCOUNT` VARCHAR(100) COMMENT '删除人',
  `DELETE_TIME` DATETIME COMMENT '删除时间',

  `CODE` VARCHAR(200) NOT NULL COMMENT '代码',
  `NAME` VARCHAR(200) NOT NULL COMMENT '名称',
  `MEMO` VARCHAR(500) COMMENT '备注',
  `STATUS` VARCHAR(10) NOT NULL COMMENT '状态（1 启用，0 停用）',

  `URI` VARCHAR(500) NOT NULL COMMENT '路由地址',

  `PATH_PREFIX` VARCHAR(100) NOT NULL COMMENT '路径前缀',

  PRIMARY KEY (`ID`),
  UNIQUE KEY `UQ_CODE` (`COMPANY_ID`,`CODE`)
)
COMMENT = '路由信息表';



insert into TB_BASE_ROUTE (ID, DELETED, CODE, NAME, STATUS, URI, PATH_PREFIX) 
values ('10', 0, 'aggr-api', '管理服务 - 聚合接口', '1', 'http://localhost:8081', '/api/aggr');

insert into TB_BASE_ROUTE (ID, DELETED, CODE, NAME, STATUS, URI, PATH_PREFIX) 
values ('11', 0, 'base-api', '管理服务 - 基础接口', '1', 'http://localhost:8082', '/api/base');
insert into TB_BASE_ROUTE (ID, DELETED, CODE, NAME, STATUS, URI, PATH_PREFIX) 
values ('12', 0, 'system-api', '管理服务 - 系统接口', '1', 'http://localhost:8082', '/api/system');
insert into TB_BASE_ROUTE (ID, DELETED, CODE, NAME, STATUS, URI, PATH_PREFIX) 
values ('13', 0, 'biz-api', '管理服务 - 业务接口', '1', 'http://localhost:8082', '/api/biz');

commit;




CREATE TABLE `TB_BASE_ACCOUNT` (
  `ID` VARCHAR(100) NOT NULL COMMENT '',
  `COMPANY_ID` VARCHAR(100) COMMENT 'CompanyID',
  `DELETED` INT(1) COMMENT '是否删除',
  `ADD_ACCOUNT` VARCHAR(100) COMMENT '创建人',
  `ADD_TIME` DATETIME COMMENT '创建时间',
  `EDIT_ACCOUNT` VARCHAR(100) COMMENT '修改人',
  `EDIT_TIME` DATETIME COMMENT '修改时间',
  `DELETE_ACCOUNT` VARCHAR(100) COMMENT '删除人',
  `DELETE_TIME` DATETIME COMMENT '删除时间',

  `USERNAME` VARCHAR(200) NOT NULL COMMENT '账号',
  `PASSWORD` VARCHAR(200) NOT NULL COMMENT '密码',

  `ENABLED` INT(11) NOT NULL COMMENT '是否可用，1 可用，0 不可用，默认：1',
  `ACCOUNT_NON_EXPIRED` INT(11) NOT NULL COMMENT '账号未过期，1 未过期，0 过期，默认：1',
  `ACCOUNT_NON_LOCKED` INT(11) NOT NULL COMMENT '账号未锁定，1 未锁定，0 锁定，默认：1',
  `CREDENTIALS_NON_EXPIRED` INT(11) NOT NULL COMMENT '密码未过期，1 未过期，0 过期，默认：1',

  `NAME` VARCHAR(200) NOT NULL COMMENT '姓名',
  `MEMO` VARCHAR(500) COMMENT '备注',
  `STATUS` VARCHAR(10) NOT NULL COMMENT '状态（1 启用，0 停用）',

  `MOBILE` VARCHAR(100) COMMENT '登录手机',
  `EMAIL` VARCHAR(100) COMMENT '登录邮箱',

  PRIMARY KEY (`ID`),
  UNIQUE KEY `UQ_USERNAME` (`USERNAME`)
)
COMMENT = '帐号表';


CREATE TABLE `TB_BASE_GROUP` (
  `ID` VARCHAR(100) NOT NULL COMMENT '',
  `COMPANY_ID` VARCHAR(100) COMMENT 'CompanyID',
  `DELETED` INT(1) COMMENT '是否删除',
  `ADD_ACCOUNT` VARCHAR(100) COMMENT '创建人',
  `ADD_TIME` DATETIME COMMENT '创建时间',
  `EDIT_ACCOUNT` VARCHAR(100) COMMENT '修改人',
  `EDIT_TIME` DATETIME COMMENT '修改时间',
  `DELETE_ACCOUNT` VARCHAR(100) COMMENT '删除人',
  `DELETE_TIME` DATETIME COMMENT '删除时间',

  `CODE` VARCHAR(200) NOT NULL COMMENT '代码',
  `NAME` VARCHAR(200) NOT NULL COMMENT '名称',
  `MEMO` VARCHAR(500) COMMENT '备注',
  `STATUS` VARCHAR(10) NOT NULL COMMENT '状态（1 启用，0 停用）',

  PRIMARY KEY (`ID`),
  UNIQUE KEY `UQ_CODE` (`COMPANY_ID`,`CODE`)
)
COMMENT = '用户组表';


CREATE TABLE `TB_BASE_ROLE` (
  `ID` VARCHAR(100) NOT NULL COMMENT '',
  `COMPANY_ID` VARCHAR(100) COMMENT 'CompanyID',
  `DELETED` INT(1) COMMENT '是否删除',
  `ADD_ACCOUNT` VARCHAR(100) COMMENT '创建人',
  `ADD_TIME` DATETIME COMMENT '创建时间',
  `EDIT_ACCOUNT` VARCHAR(100) COMMENT '修改人',
  `EDIT_TIME` DATETIME COMMENT '修改时间',
  `DELETE_ACCOUNT` VARCHAR(100) COMMENT '删除人',
  `DELETE_TIME` DATETIME COMMENT '删除时间',

  `CODE` VARCHAR(200) NOT NULL COMMENT '代码',
  `NAME` VARCHAR(200) NOT NULL COMMENT '名称',
  `MEMO` VARCHAR(500) COMMENT '备注',
  `STATUS` VARCHAR(10) NOT NULL COMMENT '状态（1 启用，0 停用）',

  PRIMARY KEY (`ID`),
  UNIQUE KEY `UQ_CODE` (`COMPANY_ID`,`CODE`)
)
COMMENT = '角色表';



CREATE TABLE `TB_BASE_ACCOUNT_GROUP` (
  `ID` VARCHAR(100) NOT NULL COMMENT '',
  `COMPANY_ID` VARCHAR(100) COMMENT 'CompanyID',
  `DELETED` INT(1) COMMENT '是否删除',
  `ADD_ACCOUNT` VARCHAR(100) COMMENT '创建人',
  `ADD_TIME` DATETIME COMMENT '创建时间',
  `EDIT_ACCOUNT` VARCHAR(100) COMMENT '修改人',
  `EDIT_TIME` DATETIME COMMENT '修改时间',
  `DELETE_ACCOUNT` VARCHAR(100) COMMENT '删除人',
  `DELETE_TIME` DATETIME COMMENT '删除时间',

  `ACCOUNT_ID` VARCHAR(200) NOT NULL COMMENT '帐号ID',
  `GROUP_ID` VARCHAR(200) NOT NULL COMMENT '用户组ID',

  PRIMARY KEY (`ID`)
)
COMMENT = '用户组 - 帐号关联表';



CREATE TABLE `TB_BASE_ACCOUNT_ROLE` (
  `ID` VARCHAR(100) NOT NULL COMMENT '',
  `COMPANY_ID` VARCHAR(100) COMMENT 'CompanyID',
  `DELETED` INT(1) COMMENT '是否删除',
  `ADD_ACCOUNT` VARCHAR(100) COMMENT '创建人',
  `ADD_TIME` DATETIME COMMENT '创建时间',
  `EDIT_ACCOUNT` VARCHAR(100) COMMENT '修改人',
  `EDIT_TIME` DATETIME COMMENT '修改时间',
  `DELETE_ACCOUNT` VARCHAR(100) COMMENT '删除人',
  `DELETE_TIME` DATETIME COMMENT '删除时间',

  `ACCOUNT_ID` VARCHAR(200) NOT NULL COMMENT '帐号ID',
  `ROLE_ID` VARCHAR(200) NOT NULL COMMENT '角色ID',

  PRIMARY KEY (`ID`)
)
COMMENT = '帐号 - 角色关联表';



CREATE TABLE `TB_BASE_GROUP_ROLE` (
  `ID` VARCHAR(100) NOT NULL COMMENT '',
  `COMPANY_ID` VARCHAR(100) COMMENT 'CompanyID',
  `DELETED` INT(1) COMMENT '是否删除',
  `ADD_ACCOUNT` VARCHAR(100) COMMENT '创建人',
  `ADD_TIME` DATETIME COMMENT '创建时间',
  `EDIT_ACCOUNT` VARCHAR(100) COMMENT '修改人',
  `EDIT_TIME` DATETIME COMMENT '修改时间',
  `DELETE_ACCOUNT` VARCHAR(100) COMMENT '删除人',
  `DELETE_TIME` DATETIME COMMENT '删除时间',

  `GROUP_ID` VARCHAR(200) NOT NULL COMMENT '用户组ID',
  `ROLE_ID` VARCHAR(200) NOT NULL COMMENT '角色ID',

  PRIMARY KEY (`ID`)
)
COMMENT = '用户组 - 角色关联表';



CREATE TABLE `TB_BASE_PERMISSION` (
  `ID` VARCHAR(100) NOT NULL COMMENT '',
  `COMPANY_ID` VARCHAR(100) COMMENT 'CompanyID',
  `DELETED` INT(1) COMMENT '是否删除',
  `ADD_ACCOUNT` VARCHAR(100) COMMENT '创建人',
  `ADD_TIME` DATETIME COMMENT '创建时间',
  `EDIT_ACCOUNT` VARCHAR(100) COMMENT '修改人',
  `EDIT_TIME` DATETIME COMMENT '修改时间',
  `DELETE_ACCOUNT` VARCHAR(100) COMMENT '删除人',
  `DELETE_TIME` DATETIME COMMENT '删除时间',

  `CODE` VARCHAR(200) NOT NULL COMMENT '代码',
  `NAME` VARCHAR(200) NOT NULL COMMENT '名称',
  `MEMO` VARCHAR(500) COMMENT '备注',
  `STATUS` VARCHAR(10) NOT NULL COMMENT '状态（1 启用，0 停用）',

  `TYPE_` VARCHAR(10) NOT NULL COMMENT '类型（1 应用，2 菜单，3 操作）',
  `ICON` VARCHAR(500) COMMENT '菜单图标',
  `URL` VARCHAR(500) COMMENT 'URL地址',

  `APPLICATION_ID` VARCHAR(100) COMMENT '系统ID', 
  `PARENT_ID` VARCHAR(100) NOT NULL COMMENT '父级ID', 
  `ORDER_` INT(11) NOT NULL COMMENT '排序',
  `LEVEL_` INT(11) NOT NULL COMMENT '层次',
  `LFT` INT(11) NOT NULL COMMENT '左索引',
  `RGT` INT(11) NOT NULL COMMENT '右索引',

  PRIMARY KEY (`ID`),
  UNIQUE KEY `UQ_CODE` (`COMPANY_ID`,`CODE`)
)
COMMENT = '权限表';



CREATE TABLE `TB_BASE_ROLE_PERMISSION` (
  `ID` VARCHAR(100) NOT NULL COMMENT '',
  `COMPANY_ID` VARCHAR(100) COMMENT 'CompanyID',
  `DELETED` INT(1) COMMENT '是否删除',
  `ADD_ACCOUNT` VARCHAR(100) COMMENT '创建人',
  `ADD_TIME` DATETIME COMMENT '创建时间',
  `EDIT_ACCOUNT` VARCHAR(100) COMMENT '修改人',
  `EDIT_TIME` DATETIME COMMENT '修改时间',
  `DELETE_ACCOUNT` VARCHAR(100) COMMENT '删除人',
  `DELETE_TIME` DATETIME COMMENT '删除时间',

  `ROLE_ID` VARCHAR(200) NOT NULL COMMENT '角色ID',
  `PERMISSION_ID` VARCHAR(200) NOT NULL COMMENT '权限ID',

  PRIMARY KEY (`ID`)
)
COMMENT = '角色 - 权限关联表';



CREATE TABLE `TB_BASE_RESOURCE` (
  `ID` VARCHAR(100) NOT NULL COMMENT '',
  `COMPANY_ID` VARCHAR(100) COMMENT 'CompanyID',
  `DELETED` INT(1) COMMENT '是否删除',
  `ADD_ACCOUNT` VARCHAR(100) COMMENT '创建人',
  `ADD_TIME` DATETIME COMMENT '创建时间',
  `EDIT_ACCOUNT` VARCHAR(100) COMMENT '修改人',
  `EDIT_TIME` DATETIME COMMENT '修改时间',
  `DELETE_ACCOUNT` VARCHAR(100) COMMENT '删除人',
  `DELETE_TIME` DATETIME COMMENT '删除时间',

  `CODE` VARCHAR(200) NOT NULL COMMENT '代码',
  `NAME` VARCHAR(200) NOT NULL COMMENT '名称',
  `MEMO` VARCHAR(500) COMMENT '备注',
  `STATUS` VARCHAR(10) NOT NULL COMMENT '状态（1 启用，0 停用）',

  `METHOD` VARCHAR(100) COMMENT '请求方式（GET、POST、PUT、DELETE 等）',
  `PATH` VARCHAR(500) COMMENT '请求地址',
  `ACCESS` VARCHAR(100) COMMENT '访问规则（匿名访问anonymous、认证访问authenticate、授权访问authorize、允许所有permitAll、拒绝所有denyAll）',

  PRIMARY KEY (`ID`),
  UNIQUE KEY `UQ_CODE` (`COMPANY_ID`,`CODE`)
)
COMMENT = '资源（API）表';


CREATE TABLE `TB_BASE_PERMISSION_RESOURCE` (
  `ID` VARCHAR(100) NOT NULL COMMENT '',
  `COMPANY_ID` VARCHAR(100) COMMENT 'CompanyID',
  `DELETED` INT(1) COMMENT '是否删除',
  `ADD_ACCOUNT` VARCHAR(100) COMMENT '创建人',
  `ADD_TIME` DATETIME COMMENT '创建时间',
  `EDIT_ACCOUNT` VARCHAR(100) COMMENT '修改人',
  `EDIT_TIME` DATETIME COMMENT '修改时间',
  `DELETE_ACCOUNT` VARCHAR(100) COMMENT '删除人',
  `DELETE_TIME` DATETIME COMMENT '删除时间',

  `PERMISSION_ID` VARCHAR(200) NOT NULL COMMENT '权限ID',
  `RESOURCE_ID` VARCHAR(200) NOT NULL COMMENT '资源ID',

  PRIMARY KEY (`ID`)
)
COMMENT = '权限 - 资源关联表';



insert into TB_BASE_ACCOUNT (ID, DELETED, USERNAME, PASSWORD, ENABLED, ACCOUNT_NON_EXPIRED, ACCOUNT_NON_LOCKED, CREDENTIALS_NON_EXPIRED, NAME, STATUS) 
values ('1', 0, 'swadmin', 'swadmin', 1, 1, 1, 1, 'Supwisdom Admin', '1');

commit;


insert into TB_BASE_GROUP (ID, DELETED, CODE, NAME, STATUS) 
values ('1', 0, 'users', '所有用户', '1');

commit;


insert into TB_BASE_ROLE (ID, DELETED, CODE, NAME, STATUS) 
values ('1', 0, 'administrator', '超级管理员', '1');
insert into TB_BASE_ROLE (ID, DELETED, CODE, NAME, STATUS) 
values ('2', 0, 'user', '普通用户', '1');

commit;


insert into TB_BASE_ACCOUNT_GROUP (ID, DELETED, ACCOUNT_ID, GROUP_ID) 
values ('1_1', 0, '1', '1');

commit;


insert into TB_BASE_ACCOUNT_ROLE (ID, DELETED, ACCOUNT_ID, ROLE_ID) 
values ('1_1', 0, '1', '1');

insert into TB_BASE_ACCOUNT_ROLE (ID, DELETED, ACCOUNT_ID, ROLE_ID) 
values ('1_2', 0, '1', '2');

commit;


insert into TB_BASE_GROUP_ROLE (ID, DELETED, GROUP_ID, ROLE_ID) 
values ('1', 0, '1', '2');

commit;



insert into TB_BASE_PERMISSION (ID, DELETED, CODE, NAME, STATUS, TYPE_, URL, APPLICATION_ID, PARENT_ID, ORDER_, LEVEL_, LFT, RGT) 
values ('1', 0, 'admin', '树维管理后台', '1', '1', '', '1', '0', 1, 1, 1, 20);

insert into TB_BASE_PERMISSION (ID, DELETED, CODE, NAME, STATUS, TYPE_, URL, APPLICATION_ID, PARENT_ID, ORDER_, LEVEL_, LFT, RGT) 
values ('10000', 0, 'admin.base', '基础管理', '1', '2', '', '1', '1', 10000, 1, 2, 17);

insert into TB_BASE_PERMISSION (ID, DELETED, CODE, NAME, STATUS, TYPE_, URL, APPLICATION_ID, PARENT_ID, ORDER_, LEVEL_, LFT, RGT) 
values ('10100', 0, 'admin.base.account', '帐号管理', '1', '2', '', '1', '10000', 10100, 2, 3, 4);
insert into TB_BASE_PERMISSION (ID, DELETED, CODE, NAME, STATUS, TYPE_, URL, APPLICATION_ID, PARENT_ID, ORDER_, LEVEL_, LFT, RGT) 
values ('10200', 0, 'admin.base.role', '角色管理', '1', '2', '', '1', '10000', 10200, 2, 5, 6);

insert into TB_BASE_PERMISSION (ID, DELETED, CODE, NAME, STATUS, TYPE_, URL, APPLICATION_ID, PARENT_ID, ORDER_, LEVEL_, LFT, RGT) 
values ('10300', 0, 'admin.base.menu', '菜单管理', '1', '2', '', '1', '10000', 10300, 2, 7, 8);
insert into TB_BASE_PERMISSION (ID, DELETED, CODE, NAME, STATUS, TYPE_, URL, APPLICATION_ID, PARENT_ID, ORDER_, LEVEL_, LFT, RGT) 
values ('10400', 0, 'admin.base.operation', '操作管理', '1', '2', '', '1', '10000', 10400, 2, 9, 10);
insert into TB_BASE_PERMISSION (ID, DELETED, CODE, NAME, STATUS, TYPE_, URL, APPLICATION_ID, PARENT_ID, ORDER_, LEVEL_, LFT, RGT) 
values ('10500', 0, 'admin.base.resource', '资源管理', '1', '2', '', '1', '10000', 10500, 2, 11, 12);

insert into TB_BASE_PERMISSION (ID, DELETED, CODE, NAME, STATUS, TYPE_, URL, APPLICATION_ID, PARENT_ID, ORDER_, LEVEL_, LFT, RGT) 
values ('10600', 0, 'admin.base.application', '应用管理', '1', '2', '', '1', '10000', 10600, 2, 13, 14);
insert into TB_BASE_PERMISSION (ID, DELETED, CODE, NAME, STATUS, TYPE_, URL, APPLICATION_ID, PARENT_ID, ORDER_, LEVEL_, LFT, RGT) 
values ('10700', 0, 'admin.base.route', '路由管理', '1', '2', '', '1', '10000', 10700, 2, 15, 16);


insert into TB_BASE_PERMISSION (ID, DELETED, CODE, NAME, STATUS, TYPE_, URL, APPLICATION_ID, PARENT_ID, ORDER_, LEVEL_, LFT, RGT) 
values ('20000', 0, 'admin.system', '系统管理', '1', '2', '', '1', '1', 20000, 1, 18, 19);

/*
insert into TB_BASE_PERMISSION (ID, DELETED, CODE, NAME, STATUS, TYPE_, URL, APPLICATION_ID, PARENT_ID, ORDER_, LEVEL_, LFT, RGT) 
values ('10200', 0, 'admin.base.group', '用户组管理', '1', '2', '', '1', '10000', 10200, 2, 4, 5);
*/

commit;


/** 超级管理员角色的权限 */
insert into TB_BASE_ROLE_PERMISSION (ID, DELETED, ROLE_ID, PERMISSION_ID) 
select CONCAT('1_', ID), 0, '1', ID from TB_BASE_PERMISSION;

/** 普通用户角色的权限 */
insert into TB_BASE_ROLE_PERMISSION (ID, DELETED, ROLE_ID, PERMISSION_ID) 
values ('2_1', 0, '2', '1');

commit;






insert into TB_BASE_RESOURCE (ID, DELETED, CODE, NAME, STATUS, METHOD, PATH, ACCESS)
values ('1', 0, 'User.user', '获取登录信息', '1', 'GET', '/api/user', 'authenticate');


insert into TB_BASE_RESOURCE (ID, DELETED, CODE, NAME, STATUS, METHOD, PATH, ACCESS)
values ('10101', 0, 'BaseAdminAccount.query', '查询帐号', '1', 'GET', '/api/base/v1/admin/accounts', 'authorize');
insert into TB_BASE_RESOURCE (ID, DELETED, CODE, NAME, STATUS, METHOD, PATH, ACCESS)
values ('10102', 0, 'BaseAdminAccount.load', '获取帐号', '1', 'GET', '/api/base/v1/admin/accounts/{id}', 'authorize');
insert into TB_BASE_RESOURCE (ID, DELETED, CODE, NAME, STATUS, METHOD, PATH, ACCESS)
values ('10103', 0, 'BaseAdminAccount.create', '创建帐号', '1', 'POST', '/api/base/v1/admin/accounts', 'authorize');
insert into TB_BASE_RESOURCE (ID, DELETED, CODE, NAME, STATUS, METHOD, PATH, ACCESS)
values ('10104', 0, 'BaseAdminAccount.update', '修改帐号', '1', 'PUT', '/api/base/v1/admin/accounts/{id}', 'authorize');
insert into TB_BASE_RESOURCE (ID, DELETED, CODE, NAME, STATUS, METHOD, PATH, ACCESS)
values ('10105', 0, 'BaseAdminAccount.delete', '删除帐号', '1', 'DELETE', '/api/base/v1/admin/accounts/{id}', 'authorize');

insert into TB_BASE_RESOURCE (ID, DELETED, CODE, NAME, STATUS, METHOD, PATH, ACCESS)
values ('10106', 0, 'BaseAdminAccount.accountRoles', '获取帐号的角色', '1', 'GET', '/api/base/v1/admin/accounts/{id}/roles', 'authorize');
insert into TB_BASE_RESOURCE (ID, DELETED, CODE, NAME, STATUS, METHOD, PATH, ACCESS)
values ('10107', 0, 'BaseAdminAccount.relateRoles', '关联帐号的角色', '1', 'POST', '/api/base/v1/admin/accounts/{id}/roles', 'authorize');


insert into TB_BASE_RESOURCE (ID, DELETED, CODE, NAME, STATUS, METHOD, PATH, ACCESS)
values ('10201', 0, 'BaseAdminRole.query', '查询角色', '1', 'GET', '/api/base/v1/admin/roles', 'authorize');
insert into TB_BASE_RESOURCE (ID, DELETED, CODE, NAME, STATUS, METHOD, PATH, ACCESS)
values ('10202', 0, 'BaseAdminRole.load', '获取角色', '1', 'GET', '/api/base/v1/admin/roles/{id}', 'authorize');
insert into TB_BASE_RESOURCE (ID, DELETED, CODE, NAME, STATUS, METHOD, PATH, ACCESS)
values ('10203', 0, 'BaseAdminRole.create', '创建角色', '1', 'POST', '/api/base/v1/admin/roles', 'authorize');
insert into TB_BASE_RESOURCE (ID, DELETED, CODE, NAME, STATUS, METHOD, PATH, ACCESS)
values ('10204', 0, 'BaseAdminRole.update', '修改角色', '1', 'PUT', '/api/base/v1/admin/roles/{id}', 'authorize');
insert into TB_BASE_RESOURCE (ID, DELETED, CODE, NAME, STATUS, METHOD, PATH, ACCESS)
values ('10205', 0, 'BaseAdminRole.delete', '删除角色', '1', 'DELETE', '/api/base/v1/admin/roles/{id}', 'authorize');

insert into TB_BASE_RESOURCE (ID, DELETED, CODE, NAME, STATUS, METHOD, PATH, ACCESS)
values ('10206', 0, 'BaseAdminRole.roleAccounts', '获取角色的帐号', '1', 'GET', '/api/base/v1/admin/roles/{id}/accounts', 'authorize');
insert into TB_BASE_RESOURCE (ID, DELETED, CODE, NAME, STATUS, METHOD, PATH, ACCESS)
values ('10207', 0, 'BaseAdminRole.relateAccounts', '关联角色的帐号', '1', 'POST', '/api/base/v1/admin/roles/{id}/accounts', 'authorize');

insert into TB_BASE_RESOURCE (ID, DELETED, CODE, NAME, STATUS, METHOD, PATH, ACCESS)
values ('10208', 0, 'BaseAdminRole.rolePermissions', '获取角色的权限', '1', 'GET', '/api/base/v1/admin/roles/{id}/permissions', 'authorize');
insert into TB_BASE_RESOURCE (ID, DELETED, CODE, NAME, STATUS, METHOD, PATH, ACCESS)
values ('10209', 0, 'BaseAdminRole.relatePermissions', '关联角色的权限', '1', 'POST', '/api/base/v1/admin/roles/{id}/permissions', 'authorize');


insert into TB_BASE_RESOURCE (ID, DELETED, CODE, NAME, STATUS, METHOD, PATH, ACCESS)
values ('10301', 0, 'BaseAdminApplication.query', '查询应用', '1', 'GET', '/api/base/v1/admin/applications', 'authorize');
insert into TB_BASE_RESOURCE (ID, DELETED, CODE, NAME, STATUS, METHOD, PATH, ACCESS)
values ('10302', 0, 'BaseAdminApplication.load', '获取应用', '1', 'GET', '/api/base/v1/admin/applications/{id}', 'authorize');
insert into TB_BASE_RESOURCE (ID, DELETED, CODE, NAME, STATUS, METHOD, PATH, ACCESS)
values ('10303', 0, 'BaseAdminApplication.create', '创建应用', '1', 'POST', '/api/base/v1/admin/applications', 'authorize');
insert into TB_BASE_RESOURCE (ID, DELETED, CODE, NAME, STATUS, METHOD, PATH, ACCESS)
values ('10304', 0, 'BaseAdminApplication.update', '修改应用', '1', 'PUT', '/api/base/v1/admin/applications/{id}', 'authorize');
insert into TB_BASE_RESOURCE (ID, DELETED, CODE, NAME, STATUS, METHOD, PATH, ACCESS)
values ('10305', 0, 'BaseAdminApplication.delete', '删除应用', '1', 'DELETE', '/api/base/v1/admin/applications/{id}', 'authorize');


insert into TB_BASE_RESOURCE (ID, DELETED, CODE, NAME, STATUS, METHOD, PATH, ACCESS)
values ('10401', 0, 'BaseAdminMenu.query', '查询菜单', '1', 'GET', '/api/base/v1/admin/menus', 'authorize');
insert into TB_BASE_RESOURCE (ID, DELETED, CODE, NAME, STATUS, METHOD, PATH, ACCESS)
values ('10402', 0, 'BaseAdminMenu.load', '获取菜单', '1', 'GET', '/api/base/v1/admin/menus/{id}', 'authorize');
insert into TB_BASE_RESOURCE (ID, DELETED, CODE, NAME, STATUS, METHOD, PATH, ACCESS)
values ('10403', 0, 'BaseAdminMenu.create', '创建菜单', '1', 'POST', '/api/base/v1/admin/menus', 'authorize');
insert into TB_BASE_RESOURCE (ID, DELETED, CODE, NAME, STATUS, METHOD, PATH, ACCESS)
values ('10404', 0, 'BaseAdminMenu.update', '修改菜单', '1', 'PUT', '/api/base/v1/admin/menus/{id}', 'authorize');
insert into TB_BASE_RESOURCE (ID, DELETED, CODE, NAME, STATUS, METHOD, PATH, ACCESS)
values ('10405', 0, 'BaseAdminMenu.delete', '删除菜单', '1', 'DELETE', '/api/base/v1/admin/menus/{id}', 'authorize');

insert into TB_BASE_RESOURCE (ID, DELETED, CODE, NAME, STATUS, METHOD, PATH, ACCESS)
values ('10406', 0, 'BaseAdminMenu.tree', '树形菜单', '1', 'GET', '/api/base/v1/admin/menus/tree', 'authorize');


insert into TB_BASE_RESOURCE (ID, DELETED, CODE, NAME, STATUS, METHOD, PATH, ACCESS)
values ('10501', 0, 'BaseAdminOperation.query', '查询操作', '1', 'GET', '/api/base/v1/admin/operations', 'authorize');
insert into TB_BASE_RESOURCE (ID, DELETED, CODE, NAME, STATUS, METHOD, PATH, ACCESS)
values ('10502', 0, 'BaseAdminOperation.load', '获取操作', '1', 'GET', '/api/base/v1/admin/operations/{id}', 'authorize');
insert into TB_BASE_RESOURCE (ID, DELETED, CODE, NAME, STATUS, METHOD, PATH, ACCESS)
values ('10503', 0, 'BaseAdminOperation.create', '创建操作', '1', 'POST', '/api/base/v1/admin/operations', 'authorize');
insert into TB_BASE_RESOURCE (ID, DELETED, CODE, NAME, STATUS, METHOD, PATH, ACCESS)
values ('10504', 0, 'BaseAdminOperation.update', '修改操作', '1', 'PUT', '/api/base/v1/admin/operations/{id}', 'authorize');
insert into TB_BASE_RESOURCE (ID, DELETED, CODE, NAME, STATUS, METHOD, PATH, ACCESS)
values ('10505', 0, 'BaseAdminOperation.delete', '删除操作', '1', 'DELETE', '/api/base/v1/admin/operations/{id}', 'authorize');


insert into TB_BASE_RESOURCE (ID, DELETED, CODE, NAME, STATUS, METHOD, PATH, ACCESS)
values ('10601', 0, 'BaseAdminResource.query', '查询资源', '1', 'GET', '/api/base/v1/admin/resources', 'authorize');
insert into TB_BASE_RESOURCE (ID, DELETED, CODE, NAME, STATUS, METHOD, PATH, ACCESS)
values ('10602', 0, 'BaseAdminResource.load', '获取资源', '1', 'GET', '/api/base/v1/admin/resources/{id}', 'authorize');
insert into TB_BASE_RESOURCE (ID, DELETED, CODE, NAME, STATUS, METHOD, PATH, ACCESS)
values ('10603', 0, 'BaseAdminResource.create', '创建资源', '1', 'POST', '/api/base/v1/admin/resources', 'authorize');
insert into TB_BASE_RESOURCE (ID, DELETED, CODE, NAME, STATUS, METHOD, PATH, ACCESS)
values ('10604', 0, 'BaseAdminResource.update', '修改资源', '1', 'PUT', '/api/base/v1/admin/resources/{id}', 'authorize');
insert into TB_BASE_RESOURCE (ID, DELETED, CODE, NAME, STATUS, METHOD, PATH, ACCESS)
values ('10605', 0, 'BaseAdminResource.delete', '删除资源', '1', 'DELETE', '/api/system/v1/admin/resources/{id}', 'authorize');


insert into TB_BASE_RESOURCE (ID, DELETED, CODE, NAME, STATUS, METHOD, PATH, ACCESS)
values ('10701', 0, 'BaseAdminRoute.query', '查询路由', '1', 'GET', '/api/base/v1/admin/routes', 'authorize');
insert into TB_BASE_RESOURCE (ID, DELETED, CODE, NAME, STATUS, METHOD, PATH, ACCESS)
values ('10702', 0, 'BaseAdminRoute.load', '获取路由', '1', 'GET', '/api/base/v1/admin/routes/{id}', 'authorize');
insert into TB_BASE_RESOURCE (ID, DELETED, CODE, NAME, STATUS, METHOD, PATH, ACCESS)
values ('10703', 0, 'BaseAdminRoute.create', '创建路由', '1', 'POST', '/api/base/v1/admin/routes', 'authorize');
insert into TB_BASE_RESOURCE (ID, DELETED, CODE, NAME, STATUS, METHOD, PATH, ACCESS)
values ('10704', 0, 'BaseAdminRoute.update', '修改路由', '1', 'PUT', '/api/base/v1/admin/routes/{id}', 'authorize');
insert into TB_BASE_RESOURCE (ID, DELETED, CODE, NAME, STATUS, METHOD, PATH, ACCESS)
values ('10705', 0, 'BaseAdminRoute.delete', '删除路由', '1', 'DELETE', '/api/system/v1/admin/routes/{id}', 'authorize');


/*
insert into TB_BASE_RESOURCE (ID, DELETED, CODE, NAME, STATUS, METHOD, PATH, ACCESS)
values ('10111', 0, 'BaseAdminAccount.accountGroups', '获取帐号的用户组', '1', 'GET', '/api/base/v1/admin/accounts/{id}/groups', 'authorize');
insert into TB_BASE_RESOURCE (ID, DELETED, CODE, NAME, STATUS, METHOD, PATH, ACCESS)
values ('10112', 0, 'BaseAdminAccount.relateGroups', '关联帐号的用户组', '1', 'POST', '/api/base/v1/admin/accounts/{id}/groups', 'authorize');


insert into TB_BASE_RESOURCE (ID, DELETED, CODE, NAME, STATUS, METHOD, PATH, ACCESS)
values ('10211', 0, 'BaseAdminRole.roleGroups', '获取角色的用户组', '1', 'GET', '/api/base/v1/admin/roles/{id}/groups', 'authorize');
insert into TB_BASE_RESOURCE (ID, DELETED, CODE, NAME, STATUS, METHOD, PATH, ACCESS)
values ('10212', 0, 'BaseAdminRole.relateGroups', '关联角色的用户组', '1', 'POST', '/api/base/v1/admin/roles/{id}/groups', 'authorize');


insert into TB_BASE_RESOURCE (ID, DELETED, CODE, NAME, STATUS, METHOD, PATH, ACCESS)
values ('10201', 0, 'BaseAdminGroup.query', '查询用户组', '1', 'GET', '/api/base/v1/admin/groups', 'authorize');
insert into TB_BASE_RESOURCE (ID, DELETED, CODE, NAME, STATUS, METHOD, PATH, ACCESS)
values ('10202', 0, 'BaseAdminGroup.load', '获取用户组', '1', 'GET', '/api/base/v1/admin/groups/{id}', 'authorize');
insert into TB_BASE_RESOURCE (ID, DELETED, CODE, NAME, STATUS, METHOD, PATH, ACCESS)
values ('10203', 0, 'BaseAdminGroup.create', '创建用户组', '1', 'POST', '/api/base/v1/admin/groups', 'authorize');
insert into TB_BASE_RESOURCE (ID, DELETED, CODE, NAME, STATUS, METHOD, PATH, ACCESS)
values ('10204', 0, 'BaseAdminGroup.update', '修改用户组', '1', 'PUT', '/api/base/v1/admin/groups/{id}', 'authorize');
insert into TB_BASE_RESOURCE (ID, DELETED, CODE, NAME, STATUS, METHOD, PATH, ACCESS)
values ('10205', 0, 'BaseAdminGroup.delete', '删除用户组', '1', 'DELETE', '/api/base/v1/admin/groups/{id}', 'authorize');

insert into TB_BASE_RESOURCE (ID, DELETED, CODE, NAME, STATUS, METHOD, PATH, ACCESS)
values ('10206', 0, 'BaseAdminGroup.groupAccounts', '获取用户组的帐号', '1', 'GET', '/api/base/v1/admin/groups/{id}/accounts', 'authorize');
insert into TB_BASE_RESOURCE (ID, DELETED, CODE, NAME, STATUS, METHOD, PATH, ACCESS)
values ('10207', 0, 'BaseAdminGroup.relateAccounts', '关联用户组的帐号', '1', 'POST', '/api/base/v1/admin/groups/{id}/accounts', 'authorize');

insert into TB_BASE_RESOURCE (ID, DELETED, CODE, NAME, STATUS, METHOD, PATH, ACCESS)
values ('10208', 0, 'BaseAdminGroup.groupRoles', '获取用户组的角色', '1', 'GET', '/api/base/v1/admin/groups/{id}/roles', 'authorize');
insert into TB_BASE_RESOURCE (ID, DELETED, CODE, NAME, STATUS, METHOD, PATH, ACCESS)
values ('10209', 0, 'BaseAdminGroup.relateRoles', '关联用户组的角色', '1', 'POST', '/api/base/v1/admin/groups/{id}/roles', 'authorize');
*/

commit;


insert into TB_BASE_PERMISSION_RESOURCE (ID, DELETED, PERMISSION_ID, RESOURCE_ID)
values ('10100_10101', 0, '10100', '10101');
insert into TB_BASE_PERMISSION_RESOURCE (ID, DELETED, PERMISSION_ID, RESOURCE_ID)
values ('10100_10102', 0, '10100', '10102');
insert into TB_BASE_PERMISSION_RESOURCE (ID, DELETED, PERMISSION_ID, RESOURCE_ID)
values ('10100_10103', 0, '10100', '10103');
insert into TB_BASE_PERMISSION_RESOURCE (ID, DELETED, PERMISSION_ID, RESOURCE_ID)
values ('10100_10104', 0, '10100', '10104');
insert into TB_BASE_PERMISSION_RESOURCE (ID, DELETED, PERMISSION_ID, RESOURCE_ID)
values ('10100_10105', 0, '10100', '10105');
insert into TB_BASE_PERMISSION_RESOURCE (ID, DELETED, PERMISSION_ID, RESOURCE_ID)
values ('10100_10106', 0, '10100', '10106');
insert into TB_BASE_PERMISSION_RESOURCE (ID, DELETED, PERMISSION_ID, RESOURCE_ID)
values ('10100_10107', 0, '10100', '10107');

insert into TB_BASE_PERMISSION_RESOURCE (ID, DELETED, PERMISSION_ID, RESOURCE_ID)
values ('10200_10201', 0, '10200', '10201');
insert into TB_BASE_PERMISSION_RESOURCE (ID, DELETED, PERMISSION_ID, RESOURCE_ID)
values ('10200_10202', 0, '10200', '10202');
insert into TB_BASE_PERMISSION_RESOURCE (ID, DELETED, PERMISSION_ID, RESOURCE_ID)
values ('10200_10203', 0, '10200', '10203');
insert into TB_BASE_PERMISSION_RESOURCE (ID, DELETED, PERMISSION_ID, RESOURCE_ID)
values ('10200_10204', 0, '10200', '10204');
insert into TB_BASE_PERMISSION_RESOURCE (ID, DELETED, PERMISSION_ID, RESOURCE_ID)
values ('10200_10205', 0, '10200', '10205');
insert into TB_BASE_PERMISSION_RESOURCE (ID, DELETED, PERMISSION_ID, RESOURCE_ID)
values ('10200_10206', 0, '10200', '10206');
insert into TB_BASE_PERMISSION_RESOURCE (ID, DELETED, PERMISSION_ID, RESOURCE_ID)
values ('10200_10207', 0, '10200', '10207');
insert into TB_BASE_PERMISSION_RESOURCE (ID, DELETED, PERMISSION_ID, RESOURCE_ID)
values ('10200_10208', 0, '10200', '10208');
insert into TB_BASE_PERMISSION_RESOURCE (ID, DELETED, PERMISSION_ID, RESOURCE_ID)
values ('10200_10209', 0, '10200', '10209');

insert into TB_BASE_PERMISSION_RESOURCE (ID, DELETED, PERMISSION_ID, RESOURCE_ID)
values ('10300_10301', 0, '10300', '10301');
insert into TB_BASE_PERMISSION_RESOURCE (ID, DELETED, PERMISSION_ID, RESOURCE_ID)
values ('10300_10302', 0, '10300', '10302');
insert into TB_BASE_PERMISSION_RESOURCE (ID, DELETED, PERMISSION_ID, RESOURCE_ID)
values ('10300_10303', 0, '10300', '10303');
insert into TB_BASE_PERMISSION_RESOURCE (ID, DELETED, PERMISSION_ID, RESOURCE_ID)
values ('10300_10304', 0, '10300', '10304');
insert into TB_BASE_PERMISSION_RESOURCE (ID, DELETED, PERMISSION_ID, RESOURCE_ID)
values ('10300_10305', 0, '10300', '10305');

insert into TB_BASE_PERMISSION_RESOURCE (ID, DELETED, PERMISSION_ID, RESOURCE_ID)
values ('10400_10401', 0, '10400', '10401');
insert into TB_BASE_PERMISSION_RESOURCE (ID, DELETED, PERMISSION_ID, RESOURCE_ID)
values ('10400_10402', 0, '10400', '10402');
insert into TB_BASE_PERMISSION_RESOURCE (ID, DELETED, PERMISSION_ID, RESOURCE_ID)
values ('10400_10403', 0, '10400', '10403');
insert into TB_BASE_PERMISSION_RESOURCE (ID, DELETED, PERMISSION_ID, RESOURCE_ID)
values ('10400_10404', 0, '10400', '10404');
insert into TB_BASE_PERMISSION_RESOURCE (ID, DELETED, PERMISSION_ID, RESOURCE_ID)
values ('10400_10405', 0, '10400', '10405');
insert into TB_BASE_PERMISSION_RESOURCE (ID, DELETED, PERMISSION_ID, RESOURCE_ID)
values ('10400_10406', 0, '10400', '10406');

insert into TB_BASE_PERMISSION_RESOURCE (ID, DELETED, PERMISSION_ID, RESOURCE_ID)
values ('10500_10501', 0, '10500', '10501');
insert into TB_BASE_PERMISSION_RESOURCE (ID, DELETED, PERMISSION_ID, RESOURCE_ID)
values ('10500_10502', 0, '10500', '10502');
insert into TB_BASE_PERMISSION_RESOURCE (ID, DELETED, PERMISSION_ID, RESOURCE_ID)
values ('10500_10503', 0, '10500', '10503');
insert into TB_BASE_PERMISSION_RESOURCE (ID, DELETED, PERMISSION_ID, RESOURCE_ID)
values ('10500_10504', 0, '10500', '10504');
insert into TB_BASE_PERMISSION_RESOURCE (ID, DELETED, PERMISSION_ID, RESOURCE_ID)
values ('10500_10505', 0, '10500', '10505');

insert into TB_BASE_PERMISSION_RESOURCE (ID, DELETED, PERMISSION_ID, RESOURCE_ID)
values ('10600_10601', 0, '10600', '10601');
insert into TB_BASE_PERMISSION_RESOURCE (ID, DELETED, PERMISSION_ID, RESOURCE_ID)
values ('10600_10602', 0, '10600', '10602');
insert into TB_BASE_PERMISSION_RESOURCE (ID, DELETED, PERMISSION_ID, RESOURCE_ID)
values ('10600_10603', 0, '10600', '10603');
insert into TB_BASE_PERMISSION_RESOURCE (ID, DELETED, PERMISSION_ID, RESOURCE_ID)
values ('10600_10604', 0, '10600', '10604');
insert into TB_BASE_PERMISSION_RESOURCE (ID, DELETED, PERMISSION_ID, RESOURCE_ID)
values ('10600_10605', 0, '10600', '10605');

insert into TB_BASE_PERMISSION_RESOURCE (ID, DELETED, PERMISSION_ID, RESOURCE_ID)
values ('10700_10701', 0, '10700', '10701');
insert into TB_BASE_PERMISSION_RESOURCE (ID, DELETED, PERMISSION_ID, RESOURCE_ID)
values ('10700_10702', 0, '10700', '10702');
insert into TB_BASE_PERMISSION_RESOURCE (ID, DELETED, PERMISSION_ID, RESOURCE_ID)
values ('10700_10703', 0, '10700', '10703');
insert into TB_BASE_PERMISSION_RESOURCE (ID, DELETED, PERMISSION_ID, RESOURCE_ID)
values ('10700_10704', 0, '10700', '10704');
insert into TB_BASE_PERMISSION_RESOURCE (ID, DELETED, PERMISSION_ID, RESOURCE_ID)
values ('10700_10705', 0, '10700', '10705');

commit;
