package com.supwisdom.institute.backend.admin.bff;

import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.context.annotation.Bean;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.http.server.reactive.ServerHttpResponse;
import org.springframework.web.cors.reactive.CorsUtils;
import org.springframework.web.server.ServerWebExchange;
import org.springframework.web.server.WebFilter;
import org.springframework.web.server.WebFilterChain;

import reactor.core.publisher.Mono;

import com.supwisdom.infras.security.reactive.basic.EnableInfrasBasicWebFluxApi;
import com.supwisdom.institute.backend.common.core.transmit.annotation.EnableSimpleUserTransmit;
import com.supwisdom.institute.backend.common.framework.exception.EnableCustomExceptionHandler;

import static org.springframework.web.cors.CorsConfiguration.ALL;

@SpringBootApplication

@EnableSimpleUserTransmit
@EnableCustomExceptionHandler

//@EnableInfrasOnlineDoc

//@EnableInfrasCasSecurity

//@EnableInfrasBasicApi
//@EnableInfrasJWTApi

@EnableInfrasBasicWebFluxApi
public class Application {

  public static void main(String[] args) {
    SpringApplication.run(Application.class, args);
  }
  
//  @Bean
//  public CorsFilter corsFilter() {
//    final CorsConfiguration config = new CorsConfiguration();
//    //config.setAllowCredentials(true);
//    config.addAllowedOrigin("*");
//    config.addAllowedHeader("*");
//    config.addAllowedMethod("*");
//
//    final UrlBasedCorsConfigurationSource source = new UrlBasedCorsConfigurationSource();
//    source.registerCorsConfiguration("/v2/api-docs", config);
//    source.registerCorsConfiguration("/api/**", config);  // 对 /api/** 下的请求，支持 cors 跨域请求，如不需要可以注释
//
//    return new CorsFilter(source);
//  }

  @Bean
  public WebFilter corsFilter() {
    return (ServerWebExchange ctx, WebFilterChain chain) -> {
      ServerHttpRequest request = ctx.getRequest();
      if (!CorsUtils.isCorsRequest(request)) {
        return chain.filter(ctx);
      }
      HttpHeaders requestHeaders = request.getHeaders();
      ServerHttpResponse response = ctx.getResponse();
      HttpMethod requestMethod = requestHeaders.getAccessControlRequestMethod();
      HttpHeaders headers = response.getHeaders();
      headers.add(HttpHeaders.ACCESS_CONTROL_ALLOW_ORIGIN, requestHeaders.getOrigin());
      headers.addAll(HttpHeaders.ACCESS_CONTROL_ALLOW_HEADERS, requestHeaders.getAccessControlRequestHeaders());
      if (requestMethod != null) {
        headers.add(HttpHeaders.ACCESS_CONTROL_ALLOW_METHODS, requestMethod.name());
      }
      headers.add(HttpHeaders.ACCESS_CONTROL_ALLOW_CREDENTIALS, "true");
      headers.add(HttpHeaders.ACCESS_CONTROL_EXPOSE_HEADERS, ALL);
      // headers.add(HttpHeaders.ACCESS_CONTROL_MAX_AGE, MAX_AGE);
      if (request.getMethod() == HttpMethod.OPTIONS) {
        response.setStatusCode(HttpStatus.OK);
        return Mono.empty();
      }
      return chain.filter(ctx);
    };
  }

}
