package com.supwisdom.institute.backend.admin.bff.listener;

import java.util.Timer;
import java.util.TimerTask;

import javax.servlet.ServletContextEvent;

import org.springframework.security.web.access.intercept.FilterInvocationSecurityMetadataSource;
import org.springframework.web.context.ContextLoaderListener;

import com.supwisdom.institute.backend.admin.bff.security.web.access.intercept.MyFilterInvocationSecurityMetadataSource;

import lombok.extern.slf4j.Slf4j;

@Slf4j
public class MyFilterInvocationSecurityMetadataSourceRefreshListener extends ContextLoaderListener {

  private FilterInvocationSecurityMetadataSource securityMetadataSource;
  public void setSecurityMetadataSource(FilterInvocationSecurityMetadataSource securityMetadataSource) {
    this.securityMetadataSource = securityMetadataSource;
  }

  private Timer timer = null;

  private int delay = 1; // 启动后，延迟1分钟
  private int period = 2; // 定时，每隔2分钟

  @Override
  public void contextInitialized(ServletContextEvent event) {
    // super.contextInitialized(event);
    log.info("MyFilterInvocationSecurityMetadataSourceRefreshListener.contextInitialized");

    if (securityMetadataSource instanceof MyFilterInvocationSecurityMetadataSource) {
      timer = new Timer("定时刷新权限信息", true);

      timer.scheduleAtFixedRate(new TimerTask() {

        @Override
        public void run() {
          ((MyFilterInvocationSecurityMetadataSource) securityMetadataSource).refreshRequestMap();
        }

      }, 1000 * 60 * delay, 1000 * 60 * period);

    }

  }

  @Override
  public void contextDestroyed(ServletContextEvent event) {
    // super.contextDestroyed(event);
    log.info("MyFilterInvocationSecurityMetadataSourceRefreshListener.contextDestroyed");

    if (timer != null) {
      timer.cancel();
    }
  }

}
