package com.supwisdom.institute.backend.admin.bff.security.web.access.intercept;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;

import javax.servlet.http.HttpServletRequest;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.ConfigAttribute;
import org.springframework.security.access.SecurityConfig;
import org.springframework.security.web.FilterInvocation;
import org.springframework.security.web.access.intercept.FilterInvocationSecurityMetadataSource;
import org.springframework.security.web.util.matcher.AntPathRequestMatcher;
import org.springframework.security.web.util.matcher.RequestMatcher;

import lombok.extern.slf4j.Slf4j;

@Slf4j
public class MyFilterInvocationSecurityMetadataSource implements FilterInvocationSecurityMetadataSource {
  
//  @Autowired
//  User1SecurityPermissionRemoteService user1SecurityPermissionRemoteService;

  private Map<RequestMatcher, Collection<ConfigAttribute>> requestMap = null;

  public void refreshRequestMap() {
    
    log.info("MyFilterInvocationSecurityMetadataSource.refreshRequestMap");
    
    requestMap = null;
    loadRequestMap();
  }
  
  private void loadRequestMap() {
    synchronized (MyFilterInvocationSecurityMetadataSource.class) {

      if (requestMap == null) {
        requestMap = new LinkedHashMap<RequestMatcher, Collection<ConfigAttribute>>();
        
//        String applicationCode = Constants.APPLICATION_CODE;
//        SecurityPermission securityPermission = user1SecurityPermissionRemoteService.loadPermissionsByAppcode(applicationCode, null);
//        if (securityPermission == null) {
//          return;
//        }
//  
//        Map<String, String> mapRoles = new HashMap<String, String>();
//        for (Role r : securityPermission.getRoles()) {
//          mapRoles.put(r.getId(), r.getCode());
//        }
//  
//        Map<String, Collection<ConfigAttribute>> permissionRoles = new HashMap<String, Collection<ConfigAttribute>>();
//        for (RolePermission rp : securityPermission.getRolePermissions()) {
//          if (mapRoles.containsKey(rp.getRoleId())) {
//            if (!permissionRoles.containsKey(rp.getPermissionId())) {
//              permissionRoles.put(rp.getPermissionId(), new ArrayList<ConfigAttribute>());
//            }
//            ConfigAttribute ca = new SecurityConfig(mapRoles.get(rp.getRoleId()));
//            permissionRoles.get(rp.getPermissionId()).add(ca);
//          }
//        }
//  
//        for (Permission p : securityPermission.getPermissions()) {
//          Collection<ConfigAttribute> attributes = permissionRoles.get(p.getId());
//          if (attributes == null) {
//            attributes = new ArrayList<ConfigAttribute>();
//          }
//          
//          if (p.getUrl() == null || p.getUrl().isEmpty()) {
//            continue;
//          }
//          
//          String pattern = p.getUrl();
//          String httpMethod = null;
//          
//          if (pattern.startsWith("GET ") || pattern.startsWith("POST ") || pattern.startsWith("PUT ") || pattern.startsWith("DELETE ")) {
//            httpMethod = pattern.substring(0, pattern.indexOf(" "));
//            pattern = pattern.substring(pattern.indexOf(" ")+1);
//          }
//          
//          AntPathRequestMatcher requestMatcher = new AntPathRequestMatcher(pattern, httpMethod);
//  
//          requestMap.put(requestMatcher, attributes);
//        }
      }
      
    }
  }

  /**
   * 获取当前请求关联的所有角色code {@link SecurityConfig} 用于和用户拥有的角色code 进行比对
   */
  @Override
  public Collection<ConfigAttribute> getAttributes(Object object) throws IllegalArgumentException {

    if (requestMap == null) {
      loadRequestMap();
    }

    HttpServletRequest request = ((FilterInvocation) object).getHttpRequest();

    RequestMatcher requestMatcher;
    for (Iterator<RequestMatcher> iter = requestMap.keySet().iterator(); iter.hasNext();) {
      requestMatcher = iter.next();

      if (requestMatcher.matches(request)) {
        return requestMap.get(requestMatcher);
      }
    }

    return null;
  }

  @Override
  public Collection<ConfigAttribute> getAllConfigAttributes() {

    return null;
  }

  @Override
  public boolean supports(Class<?> clazz) {

    return true;
  }

}
