package com.supwisdom.institute.backend.admin.bff.utils;

import java.util.Collection;

import org.springframework.security.core.Authentication;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.context.SecurityContextHolder;

import com.supwisdom.institute.backend.admin.bff.security.core.userdetails.MyUser;

import lombok.extern.slf4j.Slf4j;

@Slf4j
public class AuthenticationUtil {

  public static String currentUsername() {

    Authentication authentication = SecurityContextHolder.getContext().getAuthentication();

    if (authentication == null) {
      log.error("authentication is null");
      return null;
    }

    log.debug("authentication is {}", authentication.getPrincipal());

    if (!authentication.isAuthenticated()) {
      log.error("authentication is not authenticated");
      return null;
    }

    if (authentication.getPrincipal() == null) {
      log.error("authentication's principal is null");
      return null;
    }

    log.debug("authentication's principal is {}", authentication.getPrincipal());

    if (authentication.getPrincipal() instanceof MyUser) {
      return ((MyUser) authentication.getPrincipal()).getUsername();
    }

    return null;
  }

  public static MyUser currentUser() {

    Authentication authentication = SecurityContextHolder.getContext().getAuthentication();

    if (authentication == null) {
      log.error("authentication is null");
      return null;
    }

    log.debug("authentication is {}", authentication.getPrincipal());

    if (!authentication.isAuthenticated()) {
      log.error("authentication is not authenticated");
      return null;
    }

    if (authentication.getPrincipal() == null) {
      log.error("authentication's principal is null");
      return null;
    }

    log.debug("authentication's principal is {}", authentication.getPrincipal());

    if (authentication.getPrincipal() instanceof MyUser) {
      return (MyUser) authentication.getPrincipal();
    }

    return null;
  }

  public static boolean isAdministrator() {
    MyUser myUser = AuthenticationUtil.currentUser();
    if (myUser != null) {
      Collection<GrantedAuthority> grantedAuthoritys = myUser.getAuthorities();
      if (grantedAuthoritys != null && grantedAuthoritys.size() > 0) {
        for (GrantedAuthority grantedAuthority : grantedAuthoritys) {
          if ("administrator".equals(grantedAuthority.getAuthority())) {
            return true;
          }
        }
      }
    }
    return false;
  }

}
