package com.supwisdom.institute.backend.admin.bff;

import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;
//import org.springframework.cloud.openfeign.EnableFeignClients;
import org.springframework.context.annotation.Bean;
import org.springframework.web.cors.CorsConfiguration;
import org.springframework.web.cors.UrlBasedCorsConfigurationSource;
import org.springframework.web.filter.CorsFilter;

//import com.supwisdom.infras.online.doc.configuration.EnableInfrasOnlineDoc;
import com.supwisdom.infras.security.configure.basic.EnableInfrasBasicApi;
import com.supwisdom.infras.security.configure.cas.EnableInfrasCasSecurity;
import com.supwisdom.infras.security.configure.jwt.EnableInfrasJWTApi;
import com.supwisdom.institute.backend.common.core.transmit.annotation.EnableSimpleUserTransmit;

@SpringBootApplication
//@EnableFeignClients

@EnableSimpleUserTransmit

//@EnableInfrasOnlineDoc

@EnableInfrasCasSecurity

@EnableInfrasBasicApi
@EnableInfrasJWTApi
public class Application {

  public static void main(String[] args) {
    SpringApplication.run(Application.class, args);
  }
  
  @Bean
  public CorsFilter corsFilter() {
    final CorsConfiguration config = new CorsConfiguration();
    //config.setAllowCredentials(true);
    config.addAllowedOrigin("*");
    config.addAllowedHeader("*");
    config.addAllowedMethod("*");

    final UrlBasedCorsConfigurationSource source = new UrlBasedCorsConfigurationSource();
    source.registerCorsConfiguration("/v2/api-docs", config);
    source.registerCorsConfiguration("/api/**", config);  // 对 /api/** 下的请求，支持 cors 跨域请求，如不需要可以注释

    return new CorsFilter(source);
  }

}
