package com.supwisdom.institute.backend.admin.bff.configuration;

import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.security.access.AccessDecisionManager;
import org.springframework.security.web.access.intercept.FilterInvocationSecurityMetadataSource;

import com.supwisdom.infras.security.web.access.intercept.InfrasFilterSecurityInterceptor;
import com.supwisdom.institute.backend.admin.bff.security.web.access.MyAccessDecisionManager;
import com.supwisdom.institute.backend.admin.bff.security.web.access.intercept.InMemeryFilterInvocationSecurityMetadataSource;
import com.supwisdom.institute.backend.admin.bff.security.web.access.intercept.MyFilterSecurityInterceptor;

import lombok.extern.slf4j.Slf4j;

@Slf4j
@Configuration
public class InfrasFilterSecurityInterceptorConfig {

//  @Bean
//  public FilterInvocationSecurityMetadataSource securityMetadataSource() {
//    MyFilterInvocationSecurityMetadataSource securityMetadataSource = new MyFilterInvocationSecurityMetadataSource();
//    log.debug("InfrasFilterSecurityInterceptorConfig securityMetadataSource is {}", securityMetadataSource);
//
//    return securityMetadataSource;
//  }
  
  @Bean
  public FilterInvocationSecurityMetadataSource securityMetadataSource() {
    InMemeryFilterInvocationSecurityMetadataSource securityMetadataSource = new InMemeryFilterInvocationSecurityMetadataSource();
    log.debug("InfrasFilterSecurityInterceptorConfig securityMetadataSource is {}", securityMetadataSource);

    return securityMetadataSource;
  }
  
  
  @Bean
  public AccessDecisionManager accessDecisionManager() {
    MyAccessDecisionManager accessDecisionManager = new MyAccessDecisionManager();
    log.debug("InfrasFilterSecurityInterceptorConfig accessDecisionManager is {}", accessDecisionManager);

    return accessDecisionManager;
  }
  
  @Bean
  public InfrasFilterSecurityInterceptor infrasFilterSecurityInterceptor() throws Exception {
    MyFilterSecurityInterceptor myFilterSecurityInterceptor = new MyFilterSecurityInterceptor();
    myFilterSecurityInterceptor.setRejectPublicInvocations(true);
    log.debug("InfrasFilterSecurityInterceptorConfig infrasFilterSecurityInterceptor is {}", myFilterSecurityInterceptor);

    return myFilterSecurityInterceptor;
  }
  
}
